/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.AcknowledgedRestListener;

public class RestPutStoredScriptAction
extends BaseRestHandler {
    public RestPutStoredScriptAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_scripts/{lang}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_scripts/{lang}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_scripts/{lang}/{id}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_scripts/{lang}/{id}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id = request.param("id");
        String lang = request.param("lang");
        if (id == null) {
            id = lang;
            lang = null;
        }
        BytesReference content = request.requiredContent();
        if (lang != null) {
            this.deprecationLogger.deprecated("specifying lang [" + lang + "] as part of the url path is deprecated, use request content instead", new Object[0]);
        }
        PutStoredScriptRequest putRequest = new PutStoredScriptRequest(id, lang, content, request.getXContentType());
        return channel -> client.admin().cluster().putStoredScript(putRequest, new AcknowledgedRestListener<PutStoredScriptResponse>((RestChannel)channel));
    }
}

