/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.Config;
import esmska.data.Icons;
import esmska.data.Links;
import esmska.utils.L10N;
import esmska.utils.MiscUtils;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.io.IOUtils;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.awt.Mnemonics;

public class AboutFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(AboutFrame.class.getName());
    private static final String RES = "/esmska/resources/";
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Config config = Config.getInstance();
    private JButton closeButton;
    private JButton creditsButton;
    private JXHyperlink homeHyperlink;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JButton licenseButton;
    private JXHyperlink supportHyperlink;

    public AboutFrame() {
        this.initComponents();
        this.closeButton.requestFocusInWindow();
        this.getRootPane().setDefaultButton(this.closeButton);
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(Icons.get("about-16.png").getImage());
        images.add(Icons.get("about-22.png").getImage());
        images.add(Icons.get("about-32.png").getImage());
        images.add(Icons.get("about-48.png").getImage());
        this.setIconImages(images);
        String command = "close";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), command);
        this.getRootPane().getActionMap().put(command, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutFrame.this.closeButtonActionPerformed(e);
            }
        });
    }

    private void setURI(JXHyperlink jXHyperlink, URI uri) {
        try {
            jXHyperlink.setURI(uri);
        }
        catch (UnsupportedOperationException ex) {
            logger.log(Level.WARNING, "System does not support Desktop API, this URI won't work: " + uri, ex);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.creditsButton = new JButton();
        this.closeButton = new JButton();
        this.licenseButton = new JButton();
        this.jLabel5 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.homeHyperlink = new JXHyperlink();
        this.supportHyperlink = new JXHyperlink();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("esmska/resources/l10n");
        this.setTitle(bundle.getString("AboutFrame.title"));
        this.setLocationByPlatform(true);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/esmska.png")));
        this.jLabel1.setFocusable(false);
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 22));
        this.jLabel2.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText(this.jLabel2, "Esmska " + config.getLatestVersion());
        this.jLabel2.setFocusable(false);
        this.jLabel3.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText(this.jLabel3, bundle.getString("AboutFrame.jLabel3.text"));
        this.jLabel3.setFocusable(false);
        this.creditsButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/about-22.png")));
        Mnemonics.setLocalizedText(this.creditsButton, bundle.getString("AboutFrame.creditsButton.text"));
        this.creditsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutFrame.this.creditsButtonActionPerformed(evt);
            }
        });
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/close-22.png")));
        Mnemonics.setLocalizedText(this.closeButton, bundle.getString("Close_"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutFrame.this.closeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.licenseButton, bundle.getString("AboutFrame.licenseButton.text"));
        this.licenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutFrame.this.licenseButtonActionPerformed(evt);
            }
        });
        this.jLabel5.setFont(this.jLabel5.getFont().deriveFont((float)this.jLabel5.getFont().getSize() - 2.0f));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/copyleft-12.png")));
        Mnemonics.setLocalizedText(this.jLabel5, bundle.getString("AboutFrame.jLabel5.text"));
        this.jLabel5.setFocusable(false);
        this.setURI(this.homeHyperlink, Links.getURI("http://esmska.googlecode.com/"));
        Mnemonics.setLocalizedText(this.homeHyperlink, l10n.getString("AboutFrame.homeHyperlink.text"));
        this.homeHyperlink.setToolTipText(l10n.getString("AboutFrame.homeHyperlink.toolTipText"));
        this.setURI(this.supportHyperlink, Links.getURI("http://code.google.com/p/esmska/wiki/Support"));
        Mnemonics.setLocalizedText(this.supportHyperlink, l10n.getString("AboutFrame.supportHyperlink.text"));
        this.supportHyperlink.setToolTipText(l10n.getString("AboutFrame.supportHyperlink.toolTipText"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, GroupLayout.Alignment.CENTER, -1, 451, Short.MAX_VALUE).addComponent(this.homeHyperlink, GroupLayout.Alignment.CENTER, -2, -1, -2).addComponent(this.supportHyperlink, GroupLayout.Alignment.CENTER, -2, -1, -2).addComponent(this.jLabel3, GroupLayout.Alignment.CENTER, -1, 451, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.CENTER, -1, 451, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.CENTER, -1, 451, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.creditsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.licenseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 151, Short.MAX_VALUE).addComponent(this.closeButton)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -1, 171, Short.MAX_VALUE).addGap(108, 108, 108).addComponent(this.jLabel6, -1, 172, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8, -1, 157, Short.MAX_VALUE).addGap(138, 138, 138).addComponent(this.jLabel7, -1, 156, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.closeButton, this.creditsButton, this.licenseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jLabel8))).addComponent(this.homeHyperlink, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.supportHyperlink, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 48, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.creditsButton).addComponent(this.closeButton).addComponent(this.licenseButton)).addContainerGap()));
        layout.linkSize(1, this.jLabel4, this.jLabel6);
        layout.linkSize(1, this.closeButton, this.creditsButton, this.licenseButton);
        this.pack();
    }

    private void licenseButtonActionPerformed(ActionEvent evt) {
        try {
            logger.fine("Showing license...");
            String license = IOUtils.toString(this.getClass().getResourceAsStream("/esmska/resources/license.txt"), "UTF-8");
            final String agpl = IOUtils.toString(this.getClass().getResourceAsStream("/esmska/resources/gnu-agpl.txt"), "UTF-8");
            license = MiscUtils.escapeHtml(license);
            license = license.replaceAll("GNU Affero General Public License", "<a href=\"agpl\">GNU Affero General Public License</a>");
            final JTextPane tp = new JTextPane();
            tp.setContentType("text/html; charset=UTF-8");
            tp.setText("<html><pre>" + license + "</pre></html>");
            tp.setEditable(false);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            tp.setPreferredSize(new Dimension((int)d.getWidth() / 2, (int)d.getHeight() / 2));
            tp.setCaretPosition(0);
            tp.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        logger.fine("Showing GNU AGPL...");
                        tp.setText(null);
                        tp.setContentType("text/plain");
                        tp.setText(agpl);
                        tp.setCaretPosition(0);
                    }
                }
            });
            String option = l10n.getString("AboutFrame.Acknowledge");
            JOptionPane op = new JOptionPane(new JScrollPane(tp), 1, -1, null, new Object[]{option}, option);
            JDialog dialog = op.createDialog(this, l10n.getString("AboutFrame.License"));
            dialog.setResizable(true);
            dialog.pack();
            dialog.setVisible(true);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Could not show license", ex);
        }
    }

    private void creditsButtonActionPerformed(ActionEvent evt) {
        try {
            logger.fine("Showing credits...");
            String credits = IOUtils.toString(this.getClass().getResourceAsStream("/esmska/resources/credits.html"), "UTF-8");
            String translators = l10n.getString("Translators");
            if ("translator-credits".equals(translators)) {
                translators = "";
            } else {
                translators = translators.replaceAll("\n", "<br>\n").replaceAll("\n  ", "\n&nbsp;&nbsp;");
                translators = translators.replaceAll("(https://[^<]*)", "<a href=\"$1\">$1</a>");
            }
            String document = MessageFormat.format(credits, l10n.getString("Credits.authors"), l10n.getString("Credits.contributors"), l10n.getString("Credits.graphics"), l10n.getString("Credits.sponsors"), l10n.getString("Credits.translators"), translators, "http://code.google.com/p/esmska/wiki/Donators", l10n.getString("Credits.moreDonators"), MessageFormat.format(l10n.getString("Credits.packagers"), "http://code.google.com/p/esmska/wiki/Download?tm=2"));
            JTextPane tp = new JTextPane();
            tp.setContentType("text/html; charset=UTF-8");
            tp.setText(document);
            tp.setEditable(false);
            tp.setPreferredSize(new Dimension(450, 400));
            tp.setCaretPosition(0);
            tp.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                        try {
                            logger.fine("Browsing URL: " + e.getURL());
                            Desktop.getDesktop().browse(e.getURL().toURI());
                        }
                        catch (Exception ex) {
                            logger.log(Level.SEVERE, "Can't browse hyperlink: " + e.getURL(), ex);
                        }
                    }
                }
            });
            String option = l10n.getString("AboutFrame.Thank_you");
            JOptionPane op = new JOptionPane(new JScrollPane(tp), 1, -1, null, new Object[]{option}, option);
            JDialog dialog = op.createDialog(this, l10n.getString("AboutFrame.Credits"));
            dialog.setResizable(true);
            dialog.pack();
            dialog.setVisible(true);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not show credits", e);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

