/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.exif;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.exif.Exiftool;
import org.fibs.geotag.image.FileTypes;
import org.fibs.geotag.util.CommandLineTokenizer;
import org.fibs.geotag.util.FileUtil;
import org.fibs.geotag.util.InputStreamGobbler;

public class ExifWriter {
    private String xmpFileName(ImageInfo imageInfo) {
        return FileUtil.replaceExtension(imageInfo.getPath(), "xmp");
    }

    public boolean write(ImageInfo imageInfo) {
        boolean xmpFilesOnly;
        File imageFile = new File(imageInfo.getPath());
        FileTypes fileType = FileTypes.fileType(imageFile);
        File xmpFile = null;
        String xmpFileName = FileUtil.replaceExtension(imageInfo.getPath(), "xmp");
        if (xmpFileName != null) {
            xmpFile = new File(xmpFileName);
        }
        if ((xmpFilesOnly = Settings.get(Settings.SETTING.XMP_FILES_ONLY, false)) && xmpFile != null) {
            return this.write(imageInfo, true);
        }
        if (xmpFile != null && fileType == FileTypes.RAW_READ_ONLY) {
            return this.write(imageInfo, true);
        }
        if (xmpFile != null && fileType == FileTypes.CUSTOM_FILE_WITH_XMP) {
            return this.write(imageInfo, true);
        }
        if (xmpFile != null && xmpFile.exists()) {
            return this.write(imageInfo, true);
        }
        if (!xmpFilesOnly && fileType != FileTypes.RAW_READ_ONLY) {
            return this.write(imageInfo, false);
        }
        System.err.println("Won't write to " + imageInfo.getPath());
        return false;
    }

    private boolean write(ImageInfo imageInfo, boolean xmp) {
        boolean success = false;
        File argumentsFile = null;
        OutputStream argumentsOutputStream = null;
        OutputStreamWriter argumentsWriter = null;
        try {
            argumentsFile = File.createTempFile("args", null);
            argumentsFile.deleteOnExit();
            argumentsOutputStream = new FileOutputStream(argumentsFile);
            argumentsWriter = new OutputStreamWriter(argumentsOutputStream, "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            if (argumentsOutputStream != null) {
                try {
                    argumentsOutputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return false;
        }
        ArrayList<String> command = new ArrayList<String>();
        String exiftool = Settings.get(Settings.SETTING.EXIFTOOL_PATH, "exiftool");
        command.add(exiftool);
        command.add("-@");
        command.add(argumentsFile.getPath());
        List<String> arguments = null;
        arguments = xmp ? this.xmpArguments(imageInfo) : this.exifArguments(imageInfo);
        try {
            for (String argument : arguments) {
                argumentsWriter.write(String.valueOf(argument) + "\n");
            }
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ((Writer)argumentsWriter).flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            ((Writer)argumentsWriter).close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            if (argumentsOutputStream != null) {
                argumentsOutputStream.close();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.redirectErrorStream(true).start();
            ByteArrayOutputStream exiftoolOutput = new ByteArrayOutputStream();
            new InputStreamGobbler(process, (OutputStream)exiftoolOutput).start();
            process.waitFor();
            System.out.println(exiftoolOutput.toString());
            success = !exiftoolOutput.toString().contains("files weren't updated due to errors");
            exiftoolOutput.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return success;
    }

    private List<String> exifArguments(ImageInfo imageInfo) {
        String userComment;
        StringTokenizer tokenizer;
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-n");
        arguments.add("-s");
        String additionalArguments = Settings.get(Settings.SETTING.EXIFTOOL_ARGUMENTS, "");
        if (additionalArguments.length() > 0) {
            for (String argument : new CommandLineTokenizer(additionalArguments).tokenize()) {
                arguments.add(argument);
            }
        }
        arguments.add("-GPSVersionID=2 2 0 0");
        if (imageInfo.getGpsLatitude() != null) {
            double latitude = Double.parseDouble(imageInfo.getGpsLatitude());
            arguments.add("-GPSLatitudeRef=" + (latitude >= 0.0 ? (char)'N' : 'S'));
            arguments.add("-GPSLatitude=" + Math.abs(latitude));
        }
        if (imageInfo.getGpsLongitude() != null) {
            double longitude = Double.parseDouble(imageInfo.getGpsLongitude());
            arguments.add("-GPSLongitudeRef=" + (longitude >= 0.0 ? (char)'E' : 'W'));
            arguments.add("-GPSLongitude=" + Math.abs(longitude));
        }
        if (imageInfo.getGpsAltitude() != null) {
            double altitude = Double.parseDouble(imageInfo.getGpsAltitude());
            arguments.add("-GPSAltitudeRef=" + (altitude >= 0.0 ? (char)'0' : '1'));
            arguments.add("-GPSAltitude=" + Math.abs(altitude));
        }
        if (imageInfo.getGpsImgDirection() != null) {
            double direction = Double.parseDouble(imageInfo.getGpsImgDirection());
            arguments.add("-GPSImgDirection=" + direction);
            arguments.add("-GPSImgDirectionRef=T");
        }
        arguments.add("-GPSMapDatum=WGS-84");
        String gpsDatetime = imageInfo.getGpsDateTime();
        if (gpsDatetime != null && (tokenizer = new StringTokenizer(gpsDatetime)).countTokens() == 2) {
            String date = tokenizer.nextToken();
            String time = tokenizer.nextToken();
            arguments.add("-GPSDateStamp=" + date);
            arguments.add("-GPSTimeStamp=" + time);
        }
        if ((userComment = imageInfo.getUserComment()) != null) {
            arguments.add("-UserComment=" + userComment);
        }
        String locationName = imageInfo.getLocationName();
        arguments.add("-IPTC:ContentLocationName=" + (locationName == null ? "" : locationName));
        arguments.add("-IPTC:Sub-Location=" + (locationName == null ? "" : locationName));
        String city = imageInfo.getCityName();
        arguments.add("-IPTC:City=" + (city == null ? "" : city));
        String province = imageInfo.getProvinceName();
        arguments.add("-IPTC:Province-State=" + (province == null ? "" : province));
        String country = imageInfo.getCountryName();
        arguments.add("-IPTC:Country-PrimaryLocationName=" + (country == null ? "" : country));
        boolean createBackups = Settings.get(Settings.SETTING.CREATE_BACKUPS, true);
        if (!createBackups) {
            arguments.add("-overwrite_original");
        }
        for (String string : arguments) {
            System.out.print(String.valueOf(string) + ' ');
        }
        System.out.println();
        arguments.add(imageInfo.getPath());
        return arguments;
    }

    private List<String> xmpArguments(ImageInfo imageInfo) {
        StringTokenizer tokenizer;
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-n");
        arguments.add("-s");
        String additionalArguments = Settings.get(Settings.SETTING.EXIFTOOL_ARGUMENTS, "");
        if (additionalArguments.length() > 0) {
            for (String argument : new CommandLineTokenizer(additionalArguments).tokenize()) {
                arguments.add(argument);
            }
        }
        System.out.println();
        arguments.add("-XMP:GPSVersionID=2.2.0.0");
        if (imageInfo.getGpsLatitude() != null) {
            double latitude = Double.parseDouble(imageInfo.getGpsLatitude());
            arguments.add("-XMP:GPSLatitude=" + latitude);
        }
        if (imageInfo.getGpsLongitude() != null) {
            double longitude = Double.parseDouble(imageInfo.getGpsLongitude());
            arguments.add("-XMP:GPSLongitude=" + longitude);
        }
        if (imageInfo.getGpsAltitude() != null) {
            double altitude = Double.parseDouble(imageInfo.getGpsAltitude());
            arguments.add("-XMP:GPSAltitudeRef=" + (altitude >= 0.0 ? (char)'0' : '1'));
            arguments.add("-XMP:GPSAltitude=" + Math.abs(altitude));
        }
        if (imageInfo.getGpsImgDirection() != null) {
            double direction = Double.parseDouble(imageInfo.getGpsImgDirection());
            arguments.add("-XMP:GPSImgDirection=" + direction);
            arguments.add("-XMP:GPSImgDirectionRef=T");
        }
        arguments.add("-XMP:GPSMapDatum=WGS-84");
        String gpsDatetime = imageInfo.getGpsDateTime();
        if (gpsDatetime != null && (tokenizer = new StringTokenizer(gpsDatetime)).countTokens() == 2) {
            String date = tokenizer.nextToken();
            String time = tokenizer.nextToken();
            String tag = "-XMP:GPSTimeStamp=";
            if ("7.04".compareTo(Exiftool.getVersion()) <= 0) {
                tag = "-XMP:GPSDateTime=";
            }
            String zone = "";
            if (!(time.endsWith("Z") || time.contains("-") || time.contains("+"))) {
                zone = "Z";
            }
            arguments.add(String.valueOf(tag) + '\"' + date + ' ' + time + zone + '\"');
        }
        String location = imageInfo.getLocationName();
        arguments.add("-XMP:Location=" + (location == null ? "" : location));
        String city = imageInfo.getCityName();
        arguments.add("-XMP:City=" + (city == null ? "" : city));
        String state = imageInfo.getProvinceName();
        arguments.add("-XMP:State=" + (state == null ? "" : state));
        String country = imageInfo.getCountryName();
        arguments.add("-XMP:Country=" + (country == null ? "" : country));
        arguments.add(this.xmpFileName(imageInfo));
        for (String string : arguments) {
            System.out.print(String.valueOf(string) + ' ');
        }
        System.out.println();
        return arguments;
    }
}

