/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.weather;

import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;
import tim.prune.function.weather.SingleForecast;
import tim.prune.function.weather.WeatherResults;

public class WeatherTableModel
extends AbstractTableModel {
    private WeatherResults _results;
    public static final int ROW_DAY = 0;
    public static final int ROW_DESC = 1;
    public static final int ROW_WIND = 2;
    public static final int ROW_ICON = 3;
    public static final int ROW_TEMP = 4;
    public static final int ROW_HUMID = 5;
    private static final String UNITS_DEGC = I18nManager.getText("units.degreescelsius.short");
    private static final String UNITS_DEGF = I18nManager.getText("units.degreesfahrenheit.short");

    public int getColumnCount() {
        if (this._results == null) {
            return 0;
        }
        return this._results.getNumForecasts();
    }

    public String getColumnName(int n) {
        if (this._results != null && n >= 0 && n < this.getColumnCount()) {
            SingleForecast singleForecast = this._results.getForecast(n);
            if (!singleForecast.hasTimes() || singleForecast.getTimeFrom().startsWith("00")) {
                return singleForecast.getDate();
            }
            return singleForecast.getTimeFrom();
        }
        return "";
    }

    public int getRowCount() {
        return 6;
    }

    public boolean isEmpty() {
        return this.getColumnCount() == 0;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            return "";
        }
        SingleForecast singleForecast = this._results.getForecast(n2);
        if (singleForecast != null) {
            switch (n) {
                case 0: {
                    String string = singleForecast.getDayDesc() == null ? "now" : singleForecast.getDayDesc();
                    return WeatherTableModel.buildDisplayString(null, I18nManager.getText("dialog.weather.day." + string));
                }
                case 1: {
                    return WeatherTableModel.buildDisplayString(null, singleForecast.getDescription());
                }
                case 2: {
                    return WeatherTableModel.buildDisplayString(I18nManager.getText("dialog.weather.wind"), singleForecast.getWindDescription());
                }
                case 3: {
                    return singleForecast.getImageName();
                }
                case 4: {
                    return WeatherTableModel.buildDisplayString(I18nManager.getText("dialog.weather.temp"), String.valueOf(singleForecast.getTemps()) + (this._results.isCelsius() ? UNITS_DEGC : UNITS_DEGF));
                }
                case 5: {
                    return WeatherTableModel.buildDisplayString(I18nManager.getText("dialog.weather.humidity"), singleForecast.getHumidity());
                }
            }
        }
        return "";
    }

    private static final String buildDisplayString(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        return "<html>" + (string == null ? "" : String.valueOf(string) + ":&nbsp;") + "<big>" + string2.replaceAll(" ", "&nbsp;") + "</big></html>";
    }

    public void setResults(WeatherResults weatherResults) {
        this._results = weatherResults;
        this.fireTableStructureChanged();
    }

    public void clear() {
        this.setResults(null);
    }
}

