/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegenKt;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.FunctionCodegenKt;
import org.jetbrains.kotlin.backend.jvm.descriptors.JvmDescriptorWithExtraFlags;
import org.jetbrains.kotlin.backend.jvm.lower.InitializersLowering;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/FunctionCodegen;", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;)V", "getClassCodegen", "()Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getIrFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "getState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "doGenerate", "", "generate", "generateAnnotationDefaultValueIfNeeded", "methodVisitor", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "kotlin-compiler"})
public final class FunctionCodegen {
    @NotNull
    private final GenerationState state;
    @NotNull
    private final FunctionDescriptor descriptor;
    @NotNull
    private final IrFunction irFunction;
    @NotNull
    private final ClassCodegen classCodegen;

    @NotNull
    public final GenerationState getState() {
        return this.state;
    }

    @NotNull
    public final FunctionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void generate() {
        try {
            this.doGenerate();
        }
        catch (Throwable e) {
            throw (Throwable)new RuntimeException(e.getMessage() + " while generating code for:" + "\n" + DumpIrTreeKt.dump(this.irFunction), e);
        }
    }

    private final void doGenerate() {
        boolean interfaceClInit;
        JvmMethodGenericSignature signature2 = this.classCodegen.getTypeMapper().mapSignatureWithGeneric(this.descriptor, OwnerKind.IMPLEMENTATION);
        boolean isStatic = AsmUtil.isStaticMethod(ClassCodegenKt.getMemberOwnerKind(this.classCodegen.getDescriptor()), this.descriptor) || DescriptorUtils.isStaticDeclaration(this.descriptor);
        GenerationState generationState = this.classCodegen.getState();
        JvmMethodGenericSignature jvmMethodGenericSignature = signature2;
        Intrinsics.checkExpressionValueIsNotNull(jvmMethodGenericSignature, "signature");
        FrameMap frameMap = FunctionCodegenKt.createFrameMapWithReceivers(generationState, this.descriptor, jvmMethodGenericSignature, isStatic);
        int flags = (AsmUtil.getMethodAsmFlags(this.descriptor, OwnerKind.IMPLEMENTATION, this.state) | (isStatic ? 8 : 0)) ^ (DescriptorUtils.isAnnotationClass(this.descriptor.getContainingDeclaration()) ? 16 : 0) | (this.descriptor instanceof JvmDescriptorWithExtraFlags ? ((JvmDescriptorWithExtraFlags)((Object)this.descriptor)).getExtraFlags() : 0);
        boolean bl = interfaceClInit = JvmCodegenUtil.isJvmInterface(this.classCodegen.getDescriptor()) && Intrinsics.areEqual(InitializersLowering.Companion.getClinitName(), this.descriptor.getName());
        if (interfaceClInit) {
            flags ^= 0x400;
        }
        MethodVisitor methodVisitor = this.classCodegen.getVisitor().newMethod(ClassCodegenKt.getOtherOrigin(this.irFunction), flags, signature2.getAsmMethod().getName(), signature2.getAsmMethod().getDescriptor(), signature2.getGenericsSignature(), null);
        org.jetbrains.kotlin.codegen.FunctionCodegen.generateMethodAnnotations(this.descriptor, signature2.getAsmMethod(), methodVisitor, this.classCodegen, this.state.getTypeMapper());
        org.jetbrains.kotlin.codegen.FunctionCodegen.generateParameterAnnotations(this.descriptor, methodVisitor, signature2, this.classCodegen, this.state);
        if (!this.state.getClassBuilderMode().generateBodies || (flags & 0x400) != 0) {
            MethodVisitor methodVisitor2 = methodVisitor;
            Intrinsics.checkExpressionValueIsNotNull(methodVisitor2, "methodVisitor");
            this.generateAnnotationDefaultValueIfNeeded(methodVisitor2);
            methodVisitor.visitEnd();
            return;
        }
        new ExpressionCodegen(this.irFunction, frameMap, new InstructionAdapter(methodVisitor), this.classCodegen).generate();
    }

    private final void generateAnnotationDefaultValueIfNeeded(MethodVisitor methodVisitor) {
        block5: {
            KtExpression ktExpression;
            CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(this.descriptor);
            if (!DescriptorUtils.isAnnotationClass(directMember.getContainingDeclaration())) break block5;
            SourceElement source = directMember.getSource();
            PsiElement psiElement = KotlinSourceElementKt.getPsi(source);
            if (!(psiElement instanceof KtParameter)) {
                psiElement = null;
            }
            if ((ktExpression = (KtParameter)psiElement) != null && (ktExpression = ktExpression.getDefaultValue()) != null) {
                boolean bl;
                KtExpression $receiver;
                KtExpression ktExpression2 = ktExpression;
                KtExpression defaultValue = $receiver = (KtExpression)ktExpression2;
                ConstantValue<?> constant = org.jetbrains.kotlin.codegen.ExpressionCodegen.getCompileTimeConstant(defaultValue, this.state.getBindingContext(), true, this.state.getShouldInlineConstVals());
                boolean bl2 = bl = !this.state.getClassBuilderMode().generateBodies || constant != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Default value for annotation parameter should be compile time value: " + defaultValue.getText();
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (constant != null) {
                    AnnotationCodegen annotationCodegen = AnnotationCodegen.forAnnotationDefaultValue(methodVisitor, this.classCodegen, this.state.getTypeMapper());
                    KotlinType kotlinType = this.descriptor.getReturnType();
                    if (kotlinType == null) {
                        Intrinsics.throwNpe();
                    }
                    annotationCodegen.generateAnnotationDefaultValue(constant, kotlinType);
                }
            }
        }
    }

    @NotNull
    public final IrFunction getIrFunction() {
        return this.irFunction;
    }

    @NotNull
    public final ClassCodegen getClassCodegen() {
        return this.classCodegen;
    }

    public FunctionCodegen(@NotNull IrFunction irFunction, @NotNull ClassCodegen classCodegen) {
        Intrinsics.checkParameterIsNotNull(irFunction, "irFunction");
        Intrinsics.checkParameterIsNotNull(classCodegen, "classCodegen");
        this.irFunction = irFunction;
        this.classCodegen = classCodegen;
        this.state = this.classCodegen.getState();
        this.descriptor = this.irFunction.getDescriptor();
    }
}

