/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.SharedPsiElementImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.templateLanguages.OuterLanguageElement;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.NullableFunction;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class MultiplePsiFilesPerDocumentFileViewProvider
extends SingleRootFileViewProvider {
    private final ConcurrentMap<Language, PsiFileImpl> myRoots = ContainerUtil.newConcurrentMap(1, 0.75f, 1);
    private MultiplePsiFilesPerDocumentFileViewProvider myOriginal = null;

    public MultiplePsiFilesPerDocumentFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean eventSystemEnabled) {
        super(manager, virtualFile, eventSystemEnabled, Language.ANY);
    }

    @Override
    @NotNull
    public abstract Language getBaseLanguage();

    @Override
    @NotNull
    public List<PsiFile> getAllFiles() {
        ArrayList<PsiFile> roots2 = new ArrayList<PsiFile>();
        for (Language language : this.getLanguages()) {
            PsiFile psi = this.getPsi(language);
            if (psi == null) continue;
            roots2.add(psi);
        }
        PsiFile base = this.getPsi(this.getBaseLanguage());
        if (!roots2.isEmpty() && roots2.get(0) != base) {
            roots2.remove(base);
            roots2.add(0, base);
        }
        ArrayList<PsiFile> arrayList = roots2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider", "getAllFiles"));
        }
        return arrayList;
    }

    protected void removeFile(Language language) {
        PsiFileImpl file2 = (PsiFileImpl)this.myRoots.remove(language);
        if (file2 != null) {
            file2.markInvalidated();
        }
    }

    @Override
    protected PsiFile getPsiInner(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider", "getPsiInner"));
        }
        PsiFileImpl file2 = (PsiFileImpl)this.myRoots.get(target);
        if (file2 == null) {
            PsiFile originalFile;
            if (this.isPhysical()) {
                VirtualFile virtualFile = this.getVirtualFile();
                if (this.isIgnored()) {
                    return null;
                }
                VirtualFile parent2 = virtualFile.getParent();
                if (parent2 != null) {
                    this.getManager().findDirectory(parent2);
                }
            }
            if (target != this.getBaseLanguage() && !this.getLanguages().contains(target)) {
                return null;
            }
            file2 = (PsiFileImpl)this.createFile(target);
            if (file2 == null) {
                return null;
            }
            if (this.myOriginal != null && (originalFile = this.myOriginal.getPsi(target)) != null) {
                file2.setOriginalFile(originalFile);
            }
            file2 = ConcurrencyUtil.cacheOrGet(this.myRoots, target, file2);
        }
        return file2;
    }

    @Override
    public PsiFile getCachedPsi(@NotNull Language target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider", "getCachedPsi"));
        }
        return (PsiFile)this.myRoots.get(target);
    }

    @Override
    public List<PsiFile> getCachedPsiFiles() {
        return ContainerUtil.mapNotNull(this.myRoots.keySet(), new NullableFunction<Language, PsiFile>(){

            @Override
            @Nullable
            public PsiFile fun(Language language) {
                return MultiplePsiFilesPerDocumentFileViewProvider.this.getCachedPsi(language);
            }
        });
    }

    @Override
    @NotNull
    public List<FileElement> getKnownTreeRoots() {
        ArrayList<FileElement> files2 = new ArrayList<FileElement>(this.myRoots.size());
        for (PsiFile file2 : this.myRoots.values()) {
            FileElement treeElement = ((PsiFileImpl)file2).getTreeElement();
            if (treeElement == null) continue;
            files2.add(treeElement);
        }
        ArrayList<FileElement> arrayList = files2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider", "getKnownTreeRoots"));
        }
        return arrayList;
    }

    public void checkAllTreesEqual() {
        Collection roots2 = this.myRoots.values();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.getManager().getProject());
        documentManager.commitAllDocuments();
        for (PsiFile root : roots2) {
            Document document = documentManager.getDocument(root);
            PsiDocumentManagerBase.checkConsistency(root, document);
            assert (root.getText().equals(document.getText()));
        }
    }

    @Override
    @NotNull
    public final MultiplePsiFilesPerDocumentFileViewProvider createCopy(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileCopy", "org/jetbrains/kotlin/com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider", "createCopy"));
        }
        MultiplePsiFilesPerDocumentFileViewProvider copy = this.cloneInner(fileCopy);
        copy.myOriginal = this.myOriginal == null ? this : this.myOriginal;
        MultiplePsiFilesPerDocumentFileViewProvider multiplePsiFilesPerDocumentFileViewProvider = copy;
        if (multiplePsiFilesPerDocumentFileViewProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider", "createCopy"));
        }
        return multiplePsiFilesPerDocumentFileViewProvider;
    }

    protected abstract MultiplePsiFilesPerDocumentFileViewProvider cloneInner(VirtualFile var1);

    @Override
    @Nullable
    public PsiElement findElementAt(int offset2, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "org/jetbrains/kotlin/com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider", "findElementAt"));
        }
        PsiFile mainRoot = this.getPsi(this.getBaseLanguage());
        PsiElement ret = null;
        for (Language language : this.getLanguages()) {
            PsiFile psiRoot;
            PsiElement psiElement;
            if (!ReflectionUtil.isAssignable(lang, language.getClass()) || lang.equals(Language.class) && !this.getLanguages().contains(language) || (psiElement = MultiplePsiFilesPerDocumentFileViewProvider.findElementAt(psiRoot = this.getPsi(language), offset2)) == null || psiElement instanceof OuterLanguageElement || ret != null && psiRoot == mainRoot) continue;
            ret = psiElement;
        }
        return ret;
    }

    @Override
    @Nullable
    public PsiElement findElementAt(int offset2) {
        return this.findElementAt(offset2, Language.class);
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset2) {
        TextRange minRange = new TextRange(0, this.getContents().length());
        PsiReference ret = null;
        for (Language language : this.getLanguages()) {
            TextRange textRange;
            PsiFile psiRoot = this.getPsi(language);
            PsiReference reference = SharedPsiElementImplUtil.findReferenceAt(psiRoot, offset2, language);
            if (reference == null || !minRange.contains(textRange = reference.getRangeInElement().shiftRight(reference.getElement().getTextRange().getStartOffset())) || textRange.contains(minRange)) continue;
            minRange = textRange;
            ret = reference;
        }
        return ret;
    }

    @Override
    public void contentsSynchronized() {
        Set<Language> languages = this.getLanguages();
        Iterator iterator2 = this.myRoots.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            if (languages.contains(entry.getKey())) continue;
            PsiFileImpl file2 = (PsiFileImpl)entry.getValue();
            iterator2.remove();
            file2.markInvalidated();
        }
        super.contentsSynchronized();
    }

    @Override
    public void markInvalidated() {
        for (PsiFileImpl file2 : this.myRoots.values()) {
            file2.markInvalidated();
        }
        super.markInvalidated();
    }
}

