/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaLightStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.JavaFileElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.LightStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILightStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;

public class JavaFileElementType
extends ILightStubFileElementType<PsiJavaFileStub> {
    public static final int STUB_VERSION = 25;

    public JavaFileElementType() {
        super("java.FILE", JavaLanguage.INSTANCE);
    }

    @Override
    public LightStubBuilder getBuilder() {
        return new JavaLightStubBuilder();
    }

    @Override
    public int getStubVersion() {
        return 25;
    }

    @Override
    public boolean shouldBuildStubFor(VirtualFile file2) {
        VirtualFile dir = file2.getParent();
        return dir == null || dir.getUserData(LanguageLevel.KEY) != null;
    }

    @Override
    public ASTNode createNode(CharSequence text2) {
        return new JavaFileElement(text2);
    }

    @Override
    public FlyweightCapableTreeStructure<LighterASTNode> parseContentsLight(ASTNode chameleon) {
        PsiBuilder builder = JavaParserUtil.createBuilder(chameleon);
        this.doParse(builder);
        return builder.getLightTree();
    }

    @Override
    public ASTNode parseContents(ASTNode chameleon) {
        PsiBuilder builder = JavaParserUtil.createBuilder(chameleon);
        this.doParse(builder);
        return builder.getTreeBuilt().getFirstChildNode();
    }

    private void doParse(PsiBuilder builder) {
        PsiBuilder.Marker root = builder.mark();
        JavaParser.INSTANCE.getFileParser().parse(builder);
        root.done(this);
    }

    @Override
    @NotNull
    public String getExternalId() {
        if ("java.FILE" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaFileElementType", "getExternalId"));
        }
        return "java.FILE";
    }

    @Override
    public void serialize(@NotNull PsiJavaFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaFileElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaFileElementType", "serialize"));
        }
        dataStream.writeBoolean(stub.isCompiled());
        dataStream.writeName(stub.getPackageName());
    }

    @Override
    @NotNull
    public PsiJavaFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaFileElementType", "deserialize"));
        }
        boolean compiled = dataStream.readBoolean();
        StringRef packName = dataStream.readName();
        PsiJavaFileStubImpl psiJavaFileStubImpl = new PsiJavaFileStubImpl(null, packName, compiled);
        if (psiJavaFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaFileElementType", "deserialize"));
        }
        return psiJavaFileStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiJavaFileStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaFileElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/kotlin/com/intellij/psi/impl/source/JavaFileElementType", "indexStub"));
        }
    }
}

