/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.util.AstUtil;

public class JsDoWhile
extends JsWhile {
    public JsDoWhile() {
    }

    public JsDoWhile(JsExpression condition, JsStatement body) {
        super(condition, body);
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitDoWhile(this);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.body = v.acceptStatement(this.body);
            this.condition = v.accept(this.condition);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsDoWhile deepCopy() {
        JsExpression conditionCopy = AstUtil.deepCopy(this.condition);
        JsStatement bodyCopy = AstUtil.deepCopy(this.body);
        JsDoWhile jsDoWhile = new JsDoWhile(conditionCopy, bodyCopy).withMetadataFrom(this);
        if (jsDoWhile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsDoWhile", "deepCopy"));
        }
        return jsDoWhile;
    }
}

