/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.extapi.psi.PsiFileBase;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.FileContentUtilCore;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtFileClassProvider;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtPlaceHolderStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.utils.CollectionsKt;

public class KtFile
extends PsiFileBase
implements PsiClassOwner,
PsiNamedElement,
KtAnnotated,
KtDeclarationContainer,
KtElement {
    private final boolean isCompiled;

    public KtFile(FileViewProvider viewProvider, boolean compiled) {
        super(viewProvider, KotlinLanguage.INSTANCE);
        this.isCompiled = compiled;
    }

    @Override
    public FileASTNode getNode() {
        return super.getNode();
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        if (kotlinFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getFileType"));
        }
        return kotlinFileType;
    }

    @Override
    public String toString() {
        return "JetFile: " + this.getName();
    }

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations() {
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            List<PsiElement> list2 = Arrays.asList(stub.getChildrenByType(KtStubElementTypes.DECLARATION_TYPES, KtDeclaration.ARRAY_FACTORY));
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getDeclarations"));
            }
            return list2;
        }
        List<KtDeclaration> list3 = PsiTreeUtil.getChildrenOfTypeAsList(this, KtDeclaration.class);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getDeclarations"));
        }
        return list3;
    }

    @Nullable
    public KtImportList getImportList() {
        return this.findChildByTypeOrClass(KtStubElementTypes.IMPORT_LIST, KtImportList.class);
    }

    @Nullable
    public KtFileAnnotationList getFileAnnotationList() {
        return this.findChildByTypeOrClass(KtStubElementTypes.FILE_ANNOTATION_LIST, KtFileAnnotationList.class);
    }

    @Nullable
    public <T extends KtElementImplStub<? extends StubElement<?>>> T findChildByTypeOrClass(@NotNull KtPlaceHolderStubElementType<T> elementType, @NotNull Class<T> elementClass) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/psi/KtFile", "findChildByTypeOrClass"));
        }
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "org/jetbrains/kotlin/psi/KtFile", "findChildByTypeOrClass"));
        }
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            StubElement importListStub = stub.findChildStubByType(elementType);
            return (T)(importListStub != null ? (KtElementImplStub)importListStub.getPsi() : null);
        }
        return (T)((KtElementImplStub)this.findChildByClass(elementClass));
    }

    @NotNull
    public List<KtImportDirective> getImportDirectives() {
        KtImportList importList = this.getImportList();
        List<KtImportDirective> list2 = importList != null ? importList.getImports() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getImportDirectives"));
        }
        return list2;
    }

    @Nullable
    public KtImportDirective findImportByAlias(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/psi/KtFile", "findImportByAlias"));
        }
        for (KtImportDirective directive : this.getImportDirectives()) {
            if (!name2.equals(directive.getAliasName())) continue;
            return directive;
        }
        return null;
    }

    @Nullable
    public KtPackageDirective getPackageDirective() {
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            StubElement packageDirectiveStub = stub.findChildStubByType(KtStubElementTypes.PACKAGE_DIRECTIVE);
            return packageDirectiveStub != null ? (KtPackageDirective)packageDirectiveStub.getPsi() : null;
        }
        return this.getPackageDirectiveByTree();
    }

    @Nullable
    private KtPackageDirective getPackageDirectiveByTree() {
        ASTNode ast = this.getNode().findChildByType(KtNodeTypes.PACKAGE_DIRECTIVE);
        return ast != null ? (KtPackageDirective)ast.getPsi() : null;
    }

    @Override
    @Deprecated
    @NotNull
    public String getPackageName() {
        String string = this.getPackageFqName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getPackageName"));
        }
        return string;
    }

    @NotNull
    public FqName getPackageFqName() {
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            FqName fqName2 = stub.getPackageFqName();
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getPackageFqName"));
            }
            return fqName2;
        }
        FqName fqName3 = this.getPackageFqNameByTree();
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getPackageFqName"));
        }
        return fqName3;
    }

    @NotNull
    public FqName getPackageFqNameByTree() {
        KtPackageDirective packageDirective = this.getPackageDirectiveByTree();
        if (packageDirective == null) {
            FqName fqName2 = FqName.ROOT;
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getPackageFqNameByTree"));
            }
            return fqName2;
        }
        FqName fqName3 = packageDirective.getFqName();
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getPackageFqNameByTree"));
        }
        return fqName3;
    }

    @Override
    @Nullable
    public KotlinFileStub getStub() {
        return (KotlinFileStub)super.getStub();
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        KtFileClassProvider fileClassProvider = ServiceManager.getService(this.getProject(), KtFileClassProvider.class);
        if (fileClassProvider != null && !this.isScript()) {
            PsiClass[] psiClassArray = fileClassProvider.getFileClasses(this);
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getClasses"));
            }
            return psiClassArray;
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    public void setPackageName(String packageName) {
    }

    @Nullable
    public KtScript getScript() {
        return PsiTreeUtil.getChildOfType(this, KtScript.class);
    }

    public boolean isScript() {
        KotlinFileStub stub = this.getStub();
        if (stub != null) {
            return stub.isScript();
        }
        return this.isScriptByTree();
    }

    public boolean isScriptByTree() {
        return this.getScript() != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = super.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getName"));
        }
        return string;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtFile", "accept"));
        }
        if (visitor2 instanceof KtVisitor) {
            this.accept((KtVisitor)visitor2, null);
        } else {
            visitor2.visitFile(this);
        }
    }

    @Override
    @NotNull
    public KtFile getContainingKtFile() {
        KtFile ktFile = this;
        if (ktFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getContainingKtFile"));
        }
        return ktFile;
    }

    @Override
    public <D> void acceptChildren(@NotNull KtVisitor<Void, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtFile", "acceptChildren"));
        }
        KtPsiUtil.visitChildren(this, visitor2, data2);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtFile", "accept"));
        }
        return visitor2.visitKtFile(this, data2);
    }

    @Override
    @NotNull
    public List<KtAnnotation> getAnnotations() {
        KtFileAnnotationList fileAnnotationList = this.getFileAnnotationList();
        if (fileAnnotationList == null) {
            List<KtAnnotation> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getAnnotations"));
            }
            return list2;
        }
        List<KtAnnotation> list3 = fileAnnotationList.getAnnotations();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getAnnotations"));
        }
        return list3;
    }

    @Override
    @NotNull
    public List<KtAnnotationEntry> getAnnotationEntries() {
        KtFileAnnotationList fileAnnotationList = this.getFileAnnotationList();
        if (fileAnnotationList == null) {
            List<KtAnnotationEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getAnnotationEntries"));
            }
            return list2;
        }
        List<KtAnnotationEntry> list3 = fileAnnotationList.getAnnotationEntries();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getAnnotationEntries"));
        }
        return list3;
    }

    @NotNull
    public List<KtAnnotationEntry> getDanglingAnnotations() {
        KotlinFileStub stub = this.getStub();
        KtModifierList[] danglingModifierLists = stub == null ? this.findChildrenByClass(KtModifierList.class) : (KtModifierList[])stub.getChildrenByType(KtStubElementTypes.MODIFIER_LIST, KtStubElementTypes.MODIFIER_LIST.getArrayFactory());
        List<KtAnnotationEntry> list2 = ArraysKt.flatMap(danglingModifierLists, new Function1<KtModifierList, Iterable<KtAnnotationEntry>>(){

            @Override
            public Iterable<KtAnnotationEntry> invoke(KtModifierList modifierList) {
                return modifierList.getAnnotationEntries();
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getDanglingAnnotations"));
        }
        return list2;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/psi/KtFile", "setName"));
        }
        PsiElement result2 = super.setName(name2);
        boolean willBeScript = name2.endsWith(".kts");
        if (this.isScript() != willBeScript) {
            FileContentUtilCore.reparseFiles(CollectionsKt.singletonOrEmptyList(this.getVirtualFile()));
        }
        return result2;
    }

    @Override
    @NotNull
    public KtElement getPsiOrParent() {
        KtFile ktFile = this;
        if (ktFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtFile", "getPsiOrParent"));
        }
        return ktFile;
    }
}

