/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.KotlinToJvmSignatureMapper;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.KotlinToJvmSignatureMapperKt;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturePropagationUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class SignaturesPropagationData {
    private static final KotlinToJvmSignatureMapper SIGNATURE_MAPPER = ServiceLoader.load(KotlinToJvmSignatureMapper.class, KotlinToJvmSignatureMapper.class.getClassLoader()).iterator().next();
    private final ValueParameters modifiedValueParameters;
    private final List<String> signatureErrors;
    private final List<FunctionDescriptor> superFunctions;

    public SignaturesPropagationData(@NotNull ClassDescriptor containingClass, @NotNull KotlinType autoReturnType, @Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> autoValueParameters, @NotNull List<TypeParameterDescriptor> autoTypeParameters, @NotNull JavaMethod method) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "<init>"));
        }
        if (autoReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoReturnType", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "<init>"));
        }
        if (autoValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoValueParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "<init>"));
        }
        if (autoTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoTypeParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "<init>"));
        }
        this.signatureErrors = new ArrayList<String>(0);
        assert (receiverType == null) : "Parameters before propagation have receiver type, but propagation should be disabled for functions compiled from Kotlin in class: " + DescriptorUtils.getFqName(containingClass);
        JavaMethodDescriptor autoMethodDescriptor = SignaturesPropagationData.createAutoMethodDescriptor(containingClass, method, autoReturnType, autoValueParameters, autoTypeParameters);
        this.superFunctions = SignaturesPropagationData.getSuperFunctionsForMethod(method, autoMethodDescriptor, containingClass);
        this.modifiedValueParameters = this.superFunctions.isEmpty() ? new ValueParameters(null, autoValueParameters, false) : this.modifyValueParametersAccordingToSuperMethods(autoValueParameters);
    }

    @NotNull
    private static JavaMethodDescriptor createAutoMethodDescriptor(@NotNull ClassDescriptor containingClass, @NotNull JavaMethod method, KotlinType autoReturnType, @NotNull List<ValueParameterDescriptor> autoValueParameters, @NotNull List<TypeParameterDescriptor> autoTypeParameters) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "createAutoMethodDescriptor"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "createAutoMethodDescriptor"));
        }
        if (autoValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoValueParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "createAutoMethodDescriptor"));
        }
        if (autoTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoTypeParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "createAutoMethodDescriptor"));
        }
        JavaMethodDescriptor autoMethodDescriptor = JavaMethodDescriptor.createJavaMethod(containingClass, Annotations.Companion.getEMPTY(), method.getName(), SourceElement.NO_SOURCE);
        autoMethodDescriptor.initialize((KotlinType)null, containingClass.getThisAsReceiverParameter(), autoTypeParameters, (List)autoValueParameters, autoReturnType, Modality.OPEN, Visibilities.PUBLIC);
        JavaMethodDescriptor javaMethodDescriptor = autoMethodDescriptor;
        if (javaMethodDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "createAutoMethodDescriptor"));
        }
        return javaMethodDescriptor;
    }

    public KotlinType getModifiedReceiverType() {
        return this.modifiedValueParameters.receiverType;
    }

    public List<ValueParameterDescriptor> getModifiedValueParameters() {
        return this.modifiedValueParameters.descriptors;
    }

    public boolean getModifiedHasStableParameterNames() {
        return this.modifiedValueParameters.hasStableParameterNames;
    }

    public List<String> getSignatureErrors() {
        return this.signatureErrors;
    }

    void reportError(String error) {
        this.signatureErrors.add(error);
    }

    private ValueParameters modifyValueParametersAccordingToSuperMethods(@NotNull List<ValueParameterDescriptor> parameters2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyValueParametersAccordingToSuperMethods"));
        }
        KotlinType resultReceiverType = null;
        ArrayList<ValueParameterDescriptor> resultParameters = new ArrayList<ValueParameterDescriptor>(parameters2.size());
        boolean shouldBeExtension = this.checkIfShouldBeExtension();
        for (final ValueParameterDescriptor originalParam : parameters2) {
            final int originalIndex = originalParam.getIndex();
            List<TypeAndName> typesFromSuperMethods = ContainerUtil.map(this.superFunctions, new Function<FunctionDescriptor, TypeAndName>(){

                @Override
                public TypeAndName fun(FunctionDescriptor superFunction) {
                    int index2;
                    ReceiverParameterDescriptor receiver = superFunction.getExtensionReceiverParameter();
                    int n = index2 = receiver != null ? originalIndex - 1 : originalIndex;
                    if (index2 == -1) {
                        assert (receiver != null) : "can't happen: index is -1, while function is not extension";
                        return new TypeAndName(receiver.getType(), originalParam.getName());
                    }
                    ValueParameterDescriptor parameter = superFunction.getValueParameters().get(index2);
                    return new TypeAndName(parameter.getType(), parameter.getName());
                }
            });
            VarargCheckResult varargCheckResult = this.checkVarargInSuperFunctions(originalParam);
            KotlinType altType = varargCheckResult.parameterType;
            if (shouldBeExtension && originalIndex == 0) {
                resultReceiverType = altType;
                continue;
            }
            Name stableName = null;
            for (int i = 0; i < this.superFunctions.size(); ++i) {
                if (!this.superFunctions.get(i).hasStableParameterNames()) continue;
                stableName = typesFromSuperMethods.get((int)i).name;
                break;
            }
            resultParameters.add(new ValueParameterDescriptorImpl(originalParam.getContainingDeclaration(), null, shouldBeExtension ? originalIndex - 1 : originalIndex, originalParam.getAnnotations(), stableName != null ? stableName : originalParam.getName(), altType, originalParam.declaresDefaultValue(), originalParam.isCrossinline(), originalParam.isNoinline(), varargCheckResult.isVararg ? DescriptorUtilsKt.getBuiltIns(originalParam).getArrayElementType(altType) : null, SourceElement.NO_SOURCE));
        }
        boolean hasStableParameterNames = CollectionsKt.any(this.superFunctions, new Function1<FunctionDescriptor, Boolean>(){

            @Override
            public Boolean invoke(FunctionDescriptor descriptor2) {
                return descriptor2.hasStableParameterNames();
            }
        });
        return new ValueParameters(resultReceiverType, resultParameters, hasStableParameterNames);
    }

    private static List<FunctionDescriptor> getSuperFunctionsForMethod(@NotNull JavaMethod method, @NotNull JavaMethodDescriptor autoMethodDescriptor, @NotNull ClassDescriptor containingClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getSuperFunctionsForMethod"));
        }
        if (autoMethodDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoMethodDescriptor", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getSuperFunctionsForMethod"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getSuperFunctionsForMethod"));
        }
        ArrayList<FunctionDescriptor> superFunctions = Lists.newArrayList();
        Name name2 = method.getName();
        Method autoSignature = null;
        boolean autoMethodContainsVararg = SignaturePropagationUtilKt.containsVarargs(autoMethodDescriptor);
        for (KotlinType supertype : containingClass.getTypeConstructor().getSupertypes()) {
            Collection<SimpleFunctionDescriptor> superFunctionCandidates = supertype.getMemberScope().getContributedFunctions(name2, NoLookupLocation.WHEN_GET_SUPER_MEMBERS);
            if (!autoMethodContainsVararg && !SignaturePropagationUtilKt.containsAnyNotTrivialSignature(superFunctionCandidates)) continue;
            if (autoSignature == null) {
                autoSignature = SIGNATURE_MAPPER.mapToJvmMethodSignature(autoMethodDescriptor);
            }
            for (SimpleFunctionDescriptor candidate : superFunctionCandidates) {
                Method candidateSignature;
                if (candidate.isSuspend() || !KotlinToJvmSignatureMapperKt.erasedSignaturesEqualIgnoringReturnTypes(autoSignature, candidateSignature = SIGNATURE_MAPPER.mapToJvmMethodSignature(candidate))) continue;
                superFunctions.add(candidate);
            }
        }
        Collections.sort(superFunctions, new Comparator<FunctionDescriptor>(){

            @Override
            public int compare(@NotNull FunctionDescriptor fun1, @NotNull FunctionDescriptor fun2) {
                if (fun1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun1", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData$3", "compare"));
                }
                if (fun2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun2", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData$3", "compare"));
                }
                FqNameUnsafe fqName1 = DescriptorUtils.getFqName(fun1.getContainingDeclaration());
                FqNameUnsafe fqName2 = DescriptorUtils.getFqName(fun2.getContainingDeclaration());
                return fqName1.asString().compareTo(fqName2.asString());
            }
        });
        return superFunctions;
    }

    private boolean checkIfShouldBeExtension() {
        boolean someSupersExtension = false;
        boolean someSupersNotExtension = false;
        for (FunctionDescriptor superFunction : this.superFunctions) {
            if (superFunction.getExtensionReceiverParameter() != null) {
                someSupersExtension = true;
                continue;
            }
            someSupersNotExtension = true;
        }
        if (someSupersExtension) {
            if (someSupersNotExtension) {
                this.reportError("Incompatible super methods: some are extension functions, some are not");
            } else {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private VarargCheckResult checkVarargInSuperFunctions(@NotNull ValueParameterDescriptor originalParam) {
        if (originalParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalParam", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "checkVarargInSuperFunctions"));
        }
        boolean someSupersVararg = false;
        boolean someSupersNotVararg = false;
        for (FunctionDescriptor superFunction : this.superFunctions) {
            int index2;
            int originalIndex = originalParam.getIndex();
            int n = index2 = superFunction.getExtensionReceiverParameter() != null ? originalIndex - 1 : originalIndex;
            if (index2 != -1 && superFunction.getValueParameters().get(index2).getVarargElementType() != null) {
                someSupersVararg = true;
                continue;
            }
            someSupersNotVararg = true;
        }
        KotlinType originalVarargElementType = originalParam.getVarargElementType();
        KotlinType originalType = originalParam.getType();
        if (someSupersVararg && someSupersNotVararg) {
            this.reportError("Incompatible super methods: some have vararg parameter, some have not");
            VarargCheckResult varargCheckResult = new VarargCheckResult(originalType, originalVarargElementType != null);
            if (varargCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "checkVarargInSuperFunctions"));
            }
            return varargCheckResult;
        }
        if (someSupersVararg && originalVarargElementType == null) {
            assert (SignaturesPropagationData.isArrayType(originalType));
            VarargCheckResult varargCheckResult = new VarargCheckResult(TypeUtils.makeNotNullable(originalType), true);
            if (varargCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "checkVarargInSuperFunctions"));
            }
            return varargCheckResult;
        }
        if (someSupersNotVararg && originalVarargElementType != null) {
            assert (SignaturesPropagationData.isArrayType(originalType));
            VarargCheckResult varargCheckResult = new VarargCheckResult(TypeUtils.makeNullable(originalType), false);
            if (varargCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "checkVarargInSuperFunctions"));
            }
            return varargCheckResult;
        }
        VarargCheckResult varargCheckResult = new VarargCheckResult(originalType, originalVarargElementType != null);
        if (varargCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "checkVarargInSuperFunctions"));
        }
        return varargCheckResult;
    }

    private static boolean isArrayType(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "isArrayType"));
        }
        return KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2);
    }

    private static class ValueParameters {
        private final KotlinType receiverType;
        private final List<ValueParameterDescriptor> descriptors;
        private final boolean hasStableParameterNames;

        public ValueParameters(@Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> descriptors, boolean hasStableParameterNames) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData$ValueParameters", "<init>"));
            }
            this.receiverType = receiverType;
            this.descriptors = descriptors;
            this.hasStableParameterNames = hasStableParameterNames;
        }
    }

    private static class TypeAndName {
        public final KotlinType type;
        public final Name name;

        public TypeAndName(KotlinType type2, Name name2) {
            this.type = type2;
            this.name = name2;
        }
    }

    private static class VarargCheckResult {
        public final KotlinType parameterType;
        public final boolean isVararg;

        public VarargCheckResult(KotlinType parameterType, boolean isVararg) {
            this.parameterType = parameterType;
            this.isVararg = isVararg;
        }
    }
}

