/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.execute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.maven.polyglot.execute.ExecuteManager;
import org.sonatype.maven.polyglot.execute.ExecuteTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ExecuteManager.class, instantiationStrategy="singleton")
public class ExecuteManagerImpl
implements ExecuteManager {
    @Requirement
    protected Logger log;
    private final Map<String, List<ExecuteTask>> modelTasks = new HashMap<String, List<ExecuteTask>>();

    @Override
    public void register(Model model, List<ExecuteTask> tasks) {
        assert (model != null);
        assert (tasks != null);
        ArrayList<ExecuteTask> copy = new ArrayList<ExecuteTask>(tasks.size());
        copy.addAll(tasks);
        this.modelTasks.put(model.getId(), Collections.unmodifiableList(copy));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registered tasks for: " + model.getId() + "=" + tasks);
        }
    }

    @Override
    public List<ExecuteTask> getTasks(Model model) {
        assert (model != null);
        List<ExecuteTask> tasks = this.modelTasks.get(model.getId());
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks;
    }

    @Override
    public void install(Model model) {
        assert (model != null);
        List<ExecuteTask> tasks = this.getTasks(model);
        if (tasks.isEmpty()) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registering tasks for: " + model.getId());
        }
        if (model.getBuild() == null) {
            model.setBuild(new Build());
        }
        Plugin plugin = new Plugin();
        plugin.setGroupId("org.sonatype.pmaven");
        plugin.setArtifactId("pmaven-maven-plugin");
        plugin.setVersion("0.8-SNAPSHOT");
        model.getBuild().addPlugin(plugin);
        List<String> goals = Collections.singletonList("execute");
        for (ExecuteTask task : tasks) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registering task: " + task);
            }
            String id = task.getId();
            PluginExecution execution = new PluginExecution();
            execution.setId(id);
            execution.setPhase(task.getPhase());
            execution.setGoals(goals);
            Xpp3Dom config = new Xpp3Dom("configuration");
            execution.setConfiguration((Object)config);
            Xpp3Dom child = new Xpp3Dom("taskId");
            child.setValue(id);
            config.addChild(child);
            plugin.addExecution(execution);
        }
    }
}

