/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;

public class DependencyGraphPathResolver {
    public static Collection<List<ComponentIdentifier>> calculatePaths(List<DependencyGraphNode> fromNodes, DependencyGraphNode toNode) {
        LinkedHashMap shortestPaths = new LinkedHashMap();
        ArrayList<ComponentIdentifier> rootPath = new ArrayList<ComponentIdentifier>();
        rootPath.add(toNode.getOwner().getComponentId());
        shortestPaths.put(toNode.getOwner(), rootPath);
        LinkedHashSet<DependencyGraphComponent> directDependees = new LinkedHashSet<DependencyGraphComponent>();
        for (DependencyGraphNode node : fromNodes) {
            directDependees.add(node.getOwner());
        }
        HashSet<DependencyGraphComponent> seen = new HashSet<DependencyGraphComponent>();
        LinkedList<DependencyGraphComponent> queue = new LinkedList<DependencyGraphComponent>();
        queue.addAll(directDependees);
        while (!queue.isEmpty()) {
            DependencyGraphComponent version = (DependencyGraphComponent)queue.getFirst();
            if (version == toNode.getOwner()) {
                queue.removeFirst();
                continue;
            }
            if (seen.add(version)) {
                for (DependencyGraphComponent dependencyGraphComponent : version.getDependents()) {
                    queue.add(0, dependencyGraphComponent);
                }
                continue;
            }
            queue.remove();
            List shortest = null;
            for (DependencyGraphComponent dependencyGraphComponent : version.getDependents()) {
                List candidate = (List)shortestPaths.get(dependencyGraphComponent);
                if (candidate == null) continue;
                if (shortest == null) {
                    shortest = candidate;
                    continue;
                }
                if (shortest.size() <= candidate.size()) continue;
                shortest = candidate;
            }
            if (shortest == null) continue;
            ArrayList<ComponentIdentifier> arrayList = new ArrayList<ComponentIdentifier>();
            arrayList.addAll(shortest);
            arrayList.add(version.getComponentId());
            shortestPaths.put(version, arrayList);
        }
        ArrayList<List<ComponentIdentifier>> paths = new ArrayList<List<ComponentIdentifier>>();
        for (DependencyGraphComponent dependencyGraphComponent : directDependees) {
            List list = (List)shortestPaths.get(dependencyGraphComponent);
            paths.add(list);
        }
        return paths;
    }
}

