/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultLibraryComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class ComponentSelectorSerializer
extends AbstractSerializer<ComponentSelector> {
    public ComponentSelector read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        if (Implementation.BUILD.getId() == id) {
            return new DefaultProjectComponentSelector(decoder.readString(), decoder.readString());
        }
        if (Implementation.MODULE.getId() == id) {
            return new DefaultModuleComponentSelector(decoder.readString(), decoder.readString(), decoder.readString());
        }
        if (Implementation.LIBRARY.getId() == id) {
            return new DefaultLibraryComponentSelector(decoder.readString(), decoder.readNullableString(), decoder.readNullableString());
        }
        throw new IllegalArgumentException("Unable to find component selector with id: " + id);
    }

    public void write(Encoder encoder, ComponentSelector value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Provided component selector may not be null");
        }
        Implementation implementation = this.resolveImplementation(value);
        encoder.writeByte(implementation.getId());
        if (implementation == Implementation.MODULE) {
            ModuleComponentSelector moduleComponentSelector = (ModuleComponentSelector)value;
            encoder.writeString((CharSequence)moduleComponentSelector.getGroup());
            encoder.writeString((CharSequence)moduleComponentSelector.getModule());
            encoder.writeString((CharSequence)moduleComponentSelector.getVersion());
        } else if (implementation == Implementation.BUILD) {
            ProjectComponentSelector projectComponentSelector = (ProjectComponentSelector)value;
            encoder.writeString((CharSequence)projectComponentSelector.getBuildName());
            encoder.writeString((CharSequence)projectComponentSelector.getProjectPath());
        } else if (implementation == Implementation.LIBRARY) {
            LibraryComponentSelector libraryComponentSelector = (LibraryComponentSelector)value;
            encoder.writeString((CharSequence)libraryComponentSelector.getProjectPath());
            encoder.writeNullableString((CharSequence)libraryComponentSelector.getLibraryName());
            encoder.writeNullableString((CharSequence)libraryComponentSelector.getVariant());
        } else {
            throw new IllegalStateException("Unsupported implementation type: " + (Object)((Object)implementation));
        }
    }

    private Implementation resolveImplementation(ComponentSelector value) {
        Implementation implementation;
        if (value instanceof ModuleComponentSelector) {
            implementation = Implementation.MODULE;
        } else if (value instanceof ProjectComponentSelector) {
            implementation = Implementation.BUILD;
        } else if (value instanceof LibraryComponentSelector) {
            implementation = Implementation.LIBRARY;
        } else {
            throw new IllegalArgumentException("Unsupported component selector class: " + value.getClass());
        }
        return implementation;
    }

    private static enum Implementation {
        MODULE(1),
        BUILD(2),
        LIBRARY(3),
        BINARY(4);

        private final byte id;

        private Implementation(byte id) {
            this.id = id;
        }

        byte getId() {
            return this.id;
        }
    }
}

