/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.ModuleDescriptorState;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ModuleSource;

abstract class AbstractMutableModuleComponentResolveMetadata
implements MutableModuleComponentResolveMetadata {
    private final ModuleDescriptorState descriptor;
    private ModuleComponentIdentifier componentId;
    private ModuleVersionIdentifier id;
    private boolean changing;
    private String status;
    private List<String> statusScheme = ComponentResolveMetadata.DEFAULT_STATUS_SCHEME;
    private ModuleSource moduleSource;
    private List<? extends DependencyMetadata> dependencies;
    private Map<String, Configuration> configurationDefinitions;
    @Nullable
    private List<ModuleComponentArtifactMetadata> artifacts;

    protected AbstractMutableModuleComponentResolveMetadata(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier, ModuleDescriptorState moduleDescriptor, Map<String, Configuration> configurations, List<? extends DependencyMetadata> dependencies) {
        this.descriptor = moduleDescriptor;
        this.componentId = componentIdentifier;
        this.id = id;
        this.status = moduleDescriptor.getStatus();
        this.dependencies = dependencies;
        this.configurationDefinitions = configurations;
    }

    protected AbstractMutableModuleComponentResolveMetadata(ModuleComponentResolveMetadata metadata) {
        this.descriptor = metadata.getDescriptor();
        this.componentId = metadata.getComponentId();
        this.id = metadata.getId();
        this.changing = metadata.isChanging();
        this.status = metadata.getStatus();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSource = metadata.getSource();
        this.configurationDefinitions = metadata.getConfigurationDefinitions();
        this.artifacts = metadata.getArtifacts();
        this.dependencies = metadata.getDependencies();
    }

    @Override
    public ModuleComponentIdentifier getComponentId() {
        return this.componentId;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    @Override
    public void setComponentId(ModuleComponentIdentifier componentId) {
        this.componentId = componentId;
        this.id = DefaultModuleVersionIdentifier.newId(componentId);
    }

    @Override
    public ModuleDescriptorState getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public List<String> getStatusScheme() {
        return this.statusScheme;
    }

    @Override
    public void setStatusScheme(List<String> statusScheme) {
        this.statusScheme = statusScheme;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public void setChanging(boolean changing) {
        this.changing = changing;
    }

    @Override
    public ModuleSource getSource() {
        return this.moduleSource;
    }

    @Override
    public void setSource(ModuleSource source) {
        this.moduleSource = source;
    }

    @Override
    public Map<String, Configuration> getConfigurationDefinitions() {
        return this.configurationDefinitions;
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(String type, @Nullable String extension, @Nullable String classifier) {
        DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.getId().getName(), type, extension, classifier);
        return new DefaultModuleComponentArtifactMetadata(this.getComponentId(), ivyArtifactName);
    }

    @Override
    @Nullable
    public List<ModuleComponentArtifactMetadata> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public void setArtifacts(Iterable<? extends ModuleComponentArtifactMetadata> artifacts) {
        this.artifacts = ImmutableList.copyOf(artifacts);
    }

    @Override
    public List<? extends DependencyMetadata> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void setDependencies(Iterable<? extends DependencyMetadata> dependencies) {
        this.dependencies = ImmutableList.copyOf(dependencies);
    }
}

