/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.repository.internal;

import java.net.URI;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.artifacts.repositories.AuthenticationSupportedInternal;
import org.gradle.plugin.repository.internal.AbstractPluginRepository;
import org.gradle.plugin.repository.internal.BackedByArtifactRepositories;
import org.gradle.plugin.repository.internal.PluginRepositoryInternal;
import org.gradle.plugin.use.resolve.internal.ArtifactRepositoryPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolver;

abstract class AbstractArtifactPluginRepository
extends AbstractPluginRepository
implements AuthenticationSupported,
PluginRepositoryInternal,
BackedByArtifactRepositories {
    private static final String REPOSITORY_PREFIX = "__pluginRepository__";
    private final FileResolver fileResolver;
    private final DependencyResolutionServices dependencyResolutionServices;
    private final VersionSelectorScheme versionSelectorScheme;
    private final AuthenticationSupportedInternal authenticationSupport;
    private String name;
    private Object url;
    private PluginResolver resolver;

    AbstractArtifactPluginRepository(String defaultName, FileResolver fileResolver, DependencyResolutionServices dependencyResolutionServices, VersionSelectorScheme versionSelectorScheme, AuthenticationSupportedInternal authenticationSupport) {
        this.authenticationSupport = authenticationSupport;
        this.fileResolver = fileResolver;
        this.dependencyResolutionServices = dependencyResolutionServices;
        this.versionSelectorScheme = versionSelectorScheme;
        this.name = defaultName;
    }

    AuthenticationSupportedInternal authenticationSupport() {
        return this.authenticationSupport;
    }

    String getArtifactRepositoryName() {
        return REPOSITORY_PREFIX + this.name;
    }

    protected abstract ArtifactRepository internalCreateArtifactRepository(RepositoryHandler var1);

    @Override
    public void createArtifactRepositories(RepositoryHandler repositoryHandler) {
        this.internalCreateArtifactRepository(repositoryHandler);
    }

    public URI getUrl() {
        return this.fileResolver.resolveUri(this.url);
    }

    public void setUrl(URI url) {
        this.checkMutable();
        this.url = url;
    }

    public void setUrl(Object url) {
        this.checkMutable();
        this.url = url;
    }

    public PasswordCredentials getCredentials() {
        return this.authenticationSupport.getCredentials();
    }

    public <T extends Credentials> T getCredentials(Class<T> credentialsType) {
        return (T)this.authenticationSupport.getCredentials(credentialsType);
    }

    public void credentials(Action<? super PasswordCredentials> action) {
        this.checkMutable();
        this.authenticationSupport.credentials(action);
    }

    public <T extends Credentials> void credentials(Class<T> credentialsType, Action<? super T> action) {
        this.checkMutable();
        this.authenticationSupport.credentials(credentialsType, action);
    }

    public void authentication(Action<? super AuthenticationContainer> action) {
        this.checkMutable();
        this.authenticationSupport.authentication(action);
    }

    public AuthenticationContainer getAuthentication() {
        return this.authenticationSupport.getAuthentication();
    }

    @Override
    public PluginResolver internalAsResolver() {
        if (this.resolver == null) {
            this.createArtifactRepositories(this.dependencyResolutionServices.getResolveRepositoryHandler());
            this.resolver = new ArtifactRepositoryPluginResolver(this.name + '(' + this.url + ')', this.dependencyResolutionServices, this.versionSelectorScheme);
        }
        return this.resolver;
    }
}

