/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import com.google.common.collect.Lists;
import com.typesafe.zinc.Compiler;
import com.typesafe.zinc.SbtJars;
import com.typesafe.zinc.ScalaLocation;
import com.typesafe.zinc.Setup;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.gradle.api.logging.Logging;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheRepositoryServices;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GlobalScopeServices;
import org.gradle.internal.time.Clock;
import org.gradle.util.GFileUtils;
import sbt.ScalaInstance;
import sbt.compiler.AnalyzingCompiler;
import sbt.compiler.IC;
import scala.Function0;
import scala.Option;
import scala.runtime.AbstractFunction0;
import xsbti.Logger;
import xsbti.compile.JavaCompiler;

public class ZincScalaCompilerFactory {
    private static final org.gradle.api.logging.Logger LOGGER = Logging.getLogger(ZincScalaCompilerFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Compiler createParallelSafeCompiler(final Iterable<File> scalaClasspath, final Iterable<File> zincClasspath, final Logger logger, File gradleUserHome) {
        Compiler compiler;
        File zincCacheHomeDir = new File(System.getProperty("org.gradle.zinc.home.dir", gradleUserHome.getAbsolutePath()));
        CacheRepository cacheRepository = (CacheRepository)ZincCompilerServices.getInstance(zincCacheHomeDir).get(CacheRepository.class);
        String zincVersion = Setup.zincVersion().published();
        String zincCacheKey = String.format("zinc-%s", zincVersion);
        String zincCacheName = String.format("Zinc %s compiler cache", zincVersion);
        final PersistentCache zincCache = cacheRepository.cache(zincCacheKey).withDisplayName(zincCacheName).withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive)).open();
        try {
            File cacheDir = zincCache.getBaseDir();
            String userSuppliedZincDir = System.getProperty("zinc.dir");
            if (userSuppliedZincDir != null && !userSuppliedZincDir.equals(cacheDir.getAbsolutePath())) {
                LOGGER.warn("In order to guarantee parallel safe Scala compilation, Gradle does not support the 'zinc.dir' system property and ignores any value provided.");
            }
            compiler = (Compiler)SystemProperties.getInstance().withSystemProperty("zinc.dir", cacheDir.getAbsolutePath(), (Factory)new Factory<Compiler>(){

                public Compiler create() {
                    Setup zincSetup = ZincScalaCompilerFactory.createZincSetup(scalaClasspath, zincClasspath, logger);
                    return ZincScalaCompilerFactory.createCompiler(zincSetup, zincCache, logger);
                }
            });
        }
        finally {
            zincCache.close();
        }
        return compiler;
    }

    private static Compiler createCompiler(final Setup setup, final PersistentCache zincCache, final Logger logger) {
        return (Compiler)Compiler.compilerCache().get((Object)setup, (Function0)new AbstractFunction0<Compiler>(){

            public Compiler apply() {
                ScalaInstance instance = Compiler.scalaInstance((Setup)setup);
                File interfaceJar = ZincScalaCompilerFactory.getCompilerInterface(setup, instance, zincCache, logger);
                AnalyzingCompiler scalac = Compiler.newScalaCompiler((ScalaInstance)instance, (File)interfaceJar, (Logger)logger);
                JavaCompiler javac = Compiler.newJavaCompiler((ScalaInstance)instance, (Option)setup.javaHome(), (boolean)setup.forkJava());
                return new Compiler(scalac, javac);
            }
        });
    }

    private static File getCompilerInterface(final Setup setup, final ScalaInstance instance, PersistentCache zincCache, final Logger logger) {
        String sbtInterfaceFileName = Compiler.interfaceId((String)instance.actualVersion()) + ".jar";
        final File compilerInterface = new File(setup.cacheDir(), sbtInterfaceFileName);
        if (compilerInterface.exists()) {
            return (File)zincCache.useCache((Factory)new Factory<File>(){

                public File create() {
                    return compilerInterface;
                }
            });
        }
        try {
            File tmpDir = new File(zincCache.getBaseDir(), "tmp");
            tmpDir.mkdirs();
            final File tempFile = File.createTempFile("zinc", ".jar", tmpDir);
            Clock timer = new Clock();
            IC.compileInterfaceJar((String)sbtInterfaceFileName, (File)setup.compilerInterfaceSrc(), (File)tempFile, (File)setup.sbtInterface(), (xsbti.compile.ScalaInstance)instance, (Logger)logger);
            String interfaceCompletedMessage = String.format("Zinc interface compilation took %s", timer.getElapsed());
            if (timer.getElapsedMillis() > 30000L) {
                LOGGER.warn(interfaceCompletedMessage);
            } else {
                LOGGER.debug(interfaceCompletedMessage);
            }
            return (File)zincCache.useCache((Factory)new Factory<File>(){

                public File create() {
                    if (!compilerInterface.exists()) {
                        GFileUtils.moveFile((File)tempFile, (File)compilerInterface);
                    } else {
                        GFileUtils.deleteQuietly((File)tempFile);
                    }
                    return compilerInterface;
                }
            });
        }
        catch (IOException e) {
            return (File)zincCache.useCache((Factory)new Factory<File>(){

                public File create() {
                    return Compiler.compilerInterface((Setup)setup, (ScalaInstance)instance, (Logger)logger);
                }
            });
        }
    }

    private static Setup createZincSetup(Iterable<File> scalaClasspath, Iterable<File> zincClasspath, Logger logger) {
        ScalaLocation scalaLocation = ScalaLocation.fromPath((List)Lists.newArrayList(scalaClasspath));
        SbtJars sbtJars = SbtJars.fromPath((List)Lists.newArrayList(zincClasspath));
        Setup setup = Setup.create((ScalaLocation)scalaLocation, (SbtJars)sbtJars, (File)Jvm.current().getJavaHome(), (boolean)true);
        if (LOGGER.isDebugEnabled()) {
            Setup.debug((Setup)setup, (Logger)logger);
        }
        return setup;
    }

    private static class ZincCompilerServices
    extends DefaultServiceRegistry {
        private static ZincCompilerServices instance;

        private ZincCompilerServices(File gradleUserHome) {
            super(new ServiceRegistry[]{NativeServices.getInstance()});
            this.addProvider(new GlobalScopeServices(true));
            this.addProvider(new CacheRepositoryServices(gradleUserHome, null));
        }

        public static ZincCompilerServices getInstance(File gradleUserHome) {
            if (instance == null) {
                NativeServices.initialize((File)gradleUserHome);
                instance = new ZincCompilerServices(gradleUserHome);
            }
            return instance;
        }
    }
}

