/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingHasher
implements Hasher {
    private final Hasher delegate;
    private boolean modified;

    public TrackingHasher(Hasher delegate) {
        this.delegate = delegate;
    }

    public Hasher putByte(byte b) {
        this.markModified();
        return this.delegate.putByte(b);
    }

    public Hasher putBytes(byte[] bytes) {
        this.markModified();
        return this.delegate.putBytes(bytes);
    }

    public Hasher putBytes(byte[] bytes, int off, int len) {
        this.markModified();
        return this.delegate.putBytes(bytes, off, len);
    }

    public Hasher putShort(short s) {
        this.markModified();
        return this.delegate.putShort(s);
    }

    public Hasher putInt(int i) {
        this.markModified();
        return this.delegate.putInt(i);
    }

    public Hasher putLong(long l) {
        this.markModified();
        return this.delegate.putLong(l);
    }

    public Hasher putFloat(float f) {
        this.markModified();
        return this.delegate.putFloat(f);
    }

    public Hasher putDouble(double d) {
        this.markModified();
        return this.delegate.putDouble(d);
    }

    public Hasher putBoolean(boolean b) {
        this.markModified();
        return this.delegate.putBoolean(b);
    }

    public Hasher putChar(char c) {
        this.markModified();
        return this.delegate.putChar(c);
    }

    public Hasher putUnencodedChars(CharSequence charSequence) {
        this.markModified();
        return this.delegate.putUnencodedChars(charSequence);
    }

    public Hasher putString(CharSequence charSequence, Charset charset) {
        this.markModified();
        return this.delegate.putString(charSequence, charset);
    }

    public <T> Hasher putObject(T instance, Funnel<? super T> funnel) {
        this.markModified();
        return this.delegate.putObject(instance, funnel);
    }

    private void markModified() {
        this.modified = true;
    }

    public HashCode hash() {
        if (this.modified) {
            return this.delegate.hash();
        }
        return null;
    }
}

