/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.changedetection.state.ArrayValueSnapshot;
import org.gradle.api.internal.changedetection.state.BooleanValueSnapshot;
import org.gradle.api.internal.changedetection.state.EnumValueSnapshot;
import org.gradle.api.internal.changedetection.state.FileValueSnapshot;
import org.gradle.api.internal.changedetection.state.IntegerValueSnapshot;
import org.gradle.api.internal.changedetection.state.ListValueSnapshot;
import org.gradle.api.internal.changedetection.state.LongValueSnapshot;
import org.gradle.api.internal.changedetection.state.MapValueSnapshot;
import org.gradle.api.internal.changedetection.state.NullValueSnapshot;
import org.gradle.api.internal.changedetection.state.SerializedValueSnapshot;
import org.gradle.api.internal.changedetection.state.SetValueSnapshot;
import org.gradle.api.internal.changedetection.state.ShortValueSnapshot;
import org.gradle.api.internal.changedetection.state.StringValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;

public class ValueSnapshotter {
    private final ClassLoaderHierarchyHasher classLoaderHasher;

    public ValueSnapshotter(ClassLoaderHierarchyHasher classLoaderHasher) {
        this.classLoaderHasher = classLoaderHasher;
    }

    public ValueSnapshot snapshot(Object value) throws UncheckedIOException {
        if (value == null) {
            return NullValueSnapshot.INSTANCE;
        }
        if (value instanceof String) {
            return new StringValueSnapshot((String)value);
        }
        if (value instanceof Boolean) {
            return value.equals(Boolean.TRUE) ? BooleanValueSnapshot.TRUE : BooleanValueSnapshot.FALSE;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() == 0) {
                return ListValueSnapshot.EMPTY;
            }
            ValueSnapshot[] elements = new ValueSnapshot[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                elements[i] = this.snapshot(element);
            }
            return new ListValueSnapshot(elements);
        }
        if (value instanceof Enum) {
            return new EnumValueSnapshot((Enum)value);
        }
        if (value.getClass().equals(File.class)) {
            return new FileValueSnapshot((File)value);
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return new IntegerValueSnapshot((Integer)value);
            }
            if (value instanceof Long) {
                return new LongValueSnapshot((Long)value);
            }
            if (value instanceof Short) {
                return new ShortValueSnapshot((Short)value);
            }
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Object element : set) {
                builder.add((Object)this.snapshot(element));
            }
            return new SetValueSnapshot((ImmutableSet<ValueSnapshot>)builder.build());
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Map.Entry entry : map.entrySet()) {
                builder.put((Object)this.snapshot(entry.getKey()), (Object)this.snapshot(entry.getValue()));
            }
            return new MapValueSnapshot((ImmutableMap<ValueSnapshot, ValueSnapshot>)builder.build());
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return ArrayValueSnapshot.EMPTY;
            }
            ValueSnapshot[] elements = new ValueSnapshot[length];
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                elements[i] = this.snapshot(element);
            }
            return new ArrayValueSnapshot(elements);
        }
        return this.serialize(value);
    }

    private SerializedValueSnapshot serialize(Object value) {
        ByteArrayOutputStream outputStream;
        try {
            outputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStr = new ObjectOutputStream(outputStream);
            objectStr.writeObject(value);
            objectStr.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return new SerializedValueSnapshot(this.classLoaderHasher.getClassLoaderHash(value.getClass().getClassLoader()), outputStream.toByteArray());
    }

    public ValueSnapshot snapshot(Object value, ValueSnapshot candidate) {
        return candidate.snapshot(value, this);
    }
}

