/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import com.google.common.hash.HashCode;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysisCache;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.internal.Factory;

public class CachingClassDependenciesAnalyzer
implements ClassDependenciesAnalyzer {
    private final ClassDependenciesAnalyzer analyzer;
    private final ClassAnalysisCache cache;

    public CachingClassDependenciesAnalyzer(ClassDependenciesAnalyzer analyzer, ClassAnalysisCache cache) {
        this.analyzer = analyzer;
        this.cache = cache;
    }

    @Override
    public ClassAnalysis getClassAnalysis(final HashCode classFileHash, final FileTreeElement classFile) {
        return (ClassAnalysis)this.cache.get(classFileHash, (Factory)new Factory<ClassAnalysis>(){

            public ClassAnalysis create() {
                return CachingClassDependenciesAnalyzer.this.analyzer.getClassAnalysis(classFileHash, classFile);
            }
        });
    }
}

