/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependentsAccumulator;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;

class DefaultJarSnapshotter {
    private final FileHasher hasher;
    private final ClassDependenciesAnalyzer analyzer;

    public DefaultJarSnapshotter(FileHasher hasher, ClassDependenciesAnalyzer analyzer) {
        this.hasher = hasher;
        this.analyzer = analyzer;
    }

    public JarSnapshot createSnapshot(HashCode hash, JarArchive jarArchive) {
        final HashMap hashes = Maps.newHashMap();
        final ClassDependentsAccumulator accumulator = new ClassDependentsAccumulator();
        jarArchive.contents.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitFile(FileVisitDetails fileDetails) {
                HashCode classFileHash;
                if (!fileDetails.getName().endsWith(".class")) {
                    return;
                }
                InputStream inputStream = fileDetails.open();
                try {
                    classFileHash = DefaultJarSnapshotter.this.hasher.hash(inputStream);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException((Throwable)e);
                    }
                }
                ClassAnalysis analysis = DefaultJarSnapshotter.this.analyzer.getClassAnalysis(classFileHash, (FileTreeElement)fileDetails);
                accumulator.addClass(analysis);
                hashes.put(analysis.getClassName(), classFileHash);
            }
        });
        return new JarSnapshot(new JarSnapshotData(hash, hashes, accumulator.getAnalysis()));
    }
}

