/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core.artefact;

import grails.artefact.Artefact;
import grails.core.ArtefactHandlerAdapter;
import grails.core.ArtefactInfo;
import grails.core.GrailsApplication;
import grails.core.GrailsClass;
import grails.core.GrailsDomainClass;
import grails.core.support.GrailsApplicationAware;
import grails.persistence.Entity;
import grails.util.Environment;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.TreeSet;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.core.DefaultGrailsDomainClass;
import org.grails.core.support.GrailsDomainConfigurationUtil;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.io.support.Resource;
import org.grails.validation.ConstraintEvalUtils;
import org.springframework.core.Ordered;

public class DomainClassArtefactHandler
extends ArtefactHandlerAdapter
implements GrailsApplicationAware,
Ordered {
    public static final String TYPE = "Domain";
    public static final String PLUGIN_NAME = "domainClass";
    private Map<String, Object> defaultConstraints;
    private static boolean developmentMode = Environment.isDevelopmentMode();
    static final TreeSet<String> DOMAIN_CLASS_CACHE = new TreeSet();
    static final TreeSet<String> NOT_DOMAIN_CLASS_CACHE = new TreeSet();

    public DomainClassArtefactHandler() {
        super(TYPE, GrailsDomainClass.class, DefaultGrailsDomainClass.class, null, true);
    }

    @Override
    public void setGrailsApplication(GrailsApplication grailsApplication) {
        if (grailsApplication != null) {
            this.defaultConstraints = ConstraintEvalUtils.getDefaultConstraints(grailsApplication.getConfig());
        }
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public GrailsClass newArtefactClass(Class artefactClass) {
        return new DefaultGrailsDomainClass(artefactClass, this.defaultConstraints);
    }

    @Override
    protected boolean isArtefactResource(Resource resource) throws IOException {
        return super.isArtefactResource(resource) && GrailsResourceUtils.isDomainClass((URL)resource.getURL());
    }

    @Override
    protected boolean isValidArtefactClassNode(ClassNode classNode, int modifiers) {
        return !classNode.isEnum() && !(classNode instanceof InnerClassNode);
    }

    @Override
    public boolean isArtefact(ClassNode classNode) {
        if (classNode == null) {
            return false;
        }
        if (!this.isValidArtefactClassNode(classNode, classNode.getModifiers())) {
            return false;
        }
        URL url = GrailsASTUtils.getSourceUrl(classNode);
        if (url != null) {
            return GrailsResourceUtils.isDomainClass((URL)url);
        }
        return super.isArtefact(classNode);
    }

    @Override
    public void initialize(ArtefactInfo artefacts) {
        GrailsDomainConfigurationUtil.configureDomainClassRelationships(artefacts.getGrailsClasses(), artefacts.getGrailsClassesByName());
    }

    @Override
    public boolean isArtefactClass(Class clazz) {
        return DomainClassArtefactHandler.isDomainClass(clazz);
    }

    public static boolean isDomainClass(Class<?> clazz, boolean allowProxyClass) {
        boolean retval = DomainClassArtefactHandler.isDomainClass(clazz);
        if (!retval && allowProxyClass && clazz != null && clazz.getSimpleName().contains("$")) {
            retval = DomainClassArtefactHandler.isDomainClass(clazz.getSuperclass());
        }
        return retval;
    }

    public static boolean isDomainClass(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        String cacheKey = clazz.getName();
        if (DOMAIN_CLASS_CACHE.contains(cacheKey)) {
            return true;
        }
        if (NOT_DOMAIN_CLASS_CACHE.contains(cacheKey)) {
            return false;
        }
        boolean retval = DomainClassArtefactHandler.doIsDomainClassCheck(clazz);
        if (!developmentMode) {
            if (retval) {
                DOMAIN_CLASS_CACHE.add(cacheKey);
            } else {
                NOT_DOMAIN_CLASS_CACHE.add(cacheKey);
            }
        }
        return retval;
    }

    private static boolean doIsDomainClassCheck(Class<?> clazz) {
        if (Closure.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz.isEnum()) {
            return false;
        }
        if (clazz.getAnnotation(Entity.class) != null) {
            return true;
        }
        Artefact artefactAnn = clazz.getAnnotation(Artefact.class);
        if (artefactAnn != null && artefactAnn.value().equals(TYPE)) {
            return true;
        }
        for (Class<?> testClass = clazz; testClass != null && !testClass.equals(GroovyObject.class) && !testClass.equals(Object.class); testClass = testClass.getSuperclass()) {
            try {
                testClass.getDeclaredField("id");
                testClass.getDeclaredField("version");
                return true;
            }
            catch (SecurityException e) {
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return false;
    }

    public int getOrder() {
        return 1;
    }
}

