/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dssx;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.JmolAnnotationParser;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioResolver;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class AnnotationParser
implements JmolAnnotationParser {
    private static Map<String, String> pdbAtomForH;

    private void getAnnotationKVPairs(SV a, String match, String dotPath, SB sb, String pre, boolean showDetail, boolean isMappingOnly, int type) {
        Map map = a.getMap();
        if (map == null || map.isEmpty()) {
            return;
        }
        if (map.containsKey("_map")) {
            map = ((SV)map.get("_map")).getMap();
        }
        String detailKey = this.getDataKey(type);
        if (showDetail && map.containsKey(detailKey)) {
            if (match == null || dotPath.indexOf(match) >= 0) {
                sb.append(((SV)map.get(detailKey)).asString()).append("\n");
            }
            return;
        }
        for (Map.Entry e : map.entrySet()) {
            String key = (String)e.getKey();
            if (key.equals(detailKey)) continue;
            if (key.equals("metadata")) {
                sb.append("\n");
            }
            SV val = (SV)e.getValue();
            if (val.tok == 6) {
                if (type == 1073742189 && !showDetail) {
                    sb.append(key).append("\n");
                    continue;
                }
                this.getAnnotationKVPairs(val, match, (dotPath.length() == 0 ? "" : dotPath + ".") + key, sb, (pre.length() == 0 ? "" : pre + "\t") + key, showDetail, isMappingOnly, type);
                continue;
            }
            String s = val.asString();
            if (match != null && s.indexOf(match) < 0 && pre.indexOf(match) < 0 && key.indexOf(match) < 0 && dotPath.indexOf(match) < 0 || showDetail && isMappingOnly) continue;
            if (pre.length() > 0) {
                sb.append(pre).append("\t");
            }
            sb.append(key).append("=");
            sb.append(s).append("\n");
        }
    }

    private String getDataKey(int type) {
        switch (type) {
            case 1073741925: {
                return "mappings";
            }
            case 1073742189: {
                return "outliers";
            }
        }
        return null;
    }

    public String catalogStructureUnits(Viewer viewer, SV map0, int[] modelAtomIndices, Map<String, int[]> resMap, Object object, Map<String, Integer> modelMap) {
        String note = "Use within(rna3d, TYPE) where TYPE is one of: ";
        Map data = map0.getMap();
        if (data == null) {
            return null;
        }
        try {
            map0.mapPut("_map", SV.newV((int)6, (Object)data));
            Lst list = new Lst();
            Set set = data.entrySet();
            for (Map.Entry e : set) {
                SV sv = (SV)e.getValue();
                Lst structures = sv.getList();
                if (structures == null) continue;
                String key = (String)e.getKey();
                note = note + "\"" + key + "\" ";
                SV svPath = SV.newS((String)key);
                int j = structures.size();
                while (--j >= 0) {
                    SV struc = (SV)structures.get(j);
                    Map map = struc.getMap();
                    sv = (SV)map.get("units");
                    map.put("_isres", SV.vT);
                    Object units = sv == null || sv.tok == 7 ? sv.getList() : (sv.tok == 4 ? new Lst() : null);
                    if (units == null) continue;
                    if (sv.tok == 4) {
                        String[] svl = PT.split((String)sv.asString(), (String)",");
                        int i = svl.length;
                        while (--i >= 0) {
                            units.addLast((Object)SV.newS((String)svl[i].trim()));
                        }
                    }
                    if (units.size() <= 0) continue;
                    BS bsAtoms = new BS();
                    map.put("_atoms", SV.getVariable((Object)bsAtoms));
                    map.put("_path", svPath);
                    list.addLast((Object)struc);
                    int k = units.size();
                    while (--k >= 0) {
                        this.catalogUnit(viewer, null, ((SV)units.get(k)).asString(), 0.0f, bsAtoms, modelAtomIndices, resMap, null, modelMap);
                    }
                }
            }
            map0.mapPut("_list", SV.newV((int)7, (Object)list));
        }
        catch (Exception e) {
            Logger.info((String)(e + " while cataloging structures"));
            return null;
        }
        return note;
    }

    public Lst<Object> catalogValidations(Viewer viewer, SV map0, int[] modelAtomIndices, Map<String, int[]> resMap, Map<String, Integer> atomMap, Map<String, Integer> modelMap) {
        Map data = map0.getMap();
        if (data == null) {
            return null;
        }
        Lst retProperties = new Lst();
        int nModels = modelAtomIndices.length - 1;
        try {
            data = this.getMainItem(data).getMap();
            map0.mapPut("_map", SV.newV((int)6, (Object)data));
            Lst list = new Lst();
            map0.mapPut("_list", SV.newV((int)7, (Object)list));
            Set set = data.entrySet();
            for (Map.Entry e : set) {
                Map map;
                float[][] floats = AU.newFloat2((int)nModels);
                int m = nModels;
                while (--m >= 0) {
                    floats[m] = new float[modelAtomIndices[m + 1] - modelAtomIndices[m]];
                }
                SV sv = (SV)e.getValue();
                Lst outliers = sv.getList();
                if (outliers == null && (map = sv.getMap()) != null && (sv = (SV)map.get("outliers")) != null) {
                    outliers = sv.getList();
                }
                if (outliers == null) continue;
                boolean hasUnit = false;
                String key = (String)e.getKey();
                SV svPath = SV.newS((String)key);
                boolean isRes = false;
                int j = outliers.size();
                while (--j >= 0) {
                    float val;
                    SV out = (SV)outliers.get(j);
                    map = out.getMap();
                    sv = (SV)map.get("units");
                    SV svv = (SV)map.get("value");
                    float f = val = svv == null ? 1.0f : SV.fValue((T)svv);
                    Object units = val == 0.0f || sv == null || sv.tok == 7 ? sv.getList() : (sv.tok == 4 ? new Lst() : null);
                    if (units == null) continue;
                    if (sv.tok == 4) {
                        String[] svl = PT.split((String)sv.asString(), (String)",");
                        int i = svl.length;
                        while (--i >= 0) {
                            units.addLast((Object)SV.newS((String)svl[i].trim()));
                        }
                    }
                    if (units.size() <= 0) continue;
                    BS bsAtoms = new BS();
                    map.put("_atoms", SV.getVariable((Object)bsAtoms));
                    map.put("_path", svPath);
                    hasUnit = true;
                    list.addLast((Object)out);
                    int k = units.size();
                    while (--k >= 0) {
                        boolean ret = this.catalogUnit(viewer, floats, ((SV)units.get(k)).asString(), val, bsAtoms, modelAtomIndices, resMap, atomMap, modelMap);
                        if (ret) {
                            map.put("_isres", SV.vT);
                        }
                        isRes |= ret;
                    }
                }
                if (!hasUnit) continue;
                int m2 = nModels;
                while (--m2 >= 0) {
                    if (floats[m2] == null) continue;
                    retProperties.addLast((Object)key);
                    retProperties.addLast((Object)floats[m2]);
                    retProperties.addLast((Object)m2);
                    retProperties.addLast((Object)isRes);
                }
            }
            return retProperties;
        }
        catch (Exception e) {
            Logger.info((String)(e + " while cataloging validations"));
            return null;
        }
    }

    private SV getMainItem(Map<String, SV> data) {
        for (Map.Entry<String, SV> e : data.entrySet()) {
            String key = e.getKey();
            if (key.contains("metadata")) continue;
            return e.getValue();
        }
        return null;
    }

    public Lst<SV> initializeAnnotation(SV objAnn, int type, int modelIndex) {
        Map map = objAnn.getMap();
        SV _list = (SV)map.get("_list");
        if (_list != null) {
            return _list.getList();
        }
        String dataKey = this.getDataKey(type);
        SV main = this.getMainItem(map);
        map.put("_map", main);
        boolean noSingles = true;
        Hashtable<String, SV> _cat = new Hashtable<String, SV>();
        map.put("_cat", SV.newV((int)6, _cat));
        Lst list = new Lst();
        _list = SV.newV((int)7, (Object)list);
        map.put("_list", _list);
        for (Map.Entry e : main.getMap().entrySet()) {
            String _dbName = (String)e.getKey();
            SV _dbMap = (SV)e.getValue();
            _cat.putAll(_dbMap.getMap());
            for (Map.Entry e2 : _dbMap.getMap().entrySet()) {
                String _domainName = (String)e2.getKey();
                SV _domainMap = (SV)e2.getValue();
                SV _domainList = _domainMap.mapGet(dataKey);
                Lst _mapList = _domainList.getList();
                int i = _mapList.size();
                while (--i >= 0) {
                    SV _atoms;
                    SV mapping = (SV)_mapList.get(i);
                    list.addLast((Object)mapping);
                    Map mmap = mapping.getMap();
                    SV _chain = (SV)mmap.get("chain_id");
                    SV start = (SV)mmap.get("start");
                    SV end = (SV)mmap.get("end");
                    int res1 = 0;
                    int res2 = 0;
                    String rescode = "modelIndex=" + modelIndex + "&chain='" + _chain.value + "'";
                    if (start != null && end != null) {
                        res1 = start.mapGet((String)"residue_number").intValue;
                        res2 = end.mapGet((String)"residue_number").intValue;
                        rescode = rescode + "&seqid>=" + res1 + "&seqid<=" + res2;
                    } else {
                        res2 = 1;
                        rescode = rescode + "&seqid>0";
                    }
                    SV sV = _atoms = noSingles && res1 >= res2 ? SV.getVariable((Object)new BS()) : (SV)_cat.get(rescode);
                    if (_atoms == null) {
                        _atoms = SV.newS((String)rescode);
                        _cat.put(rescode, _atoms);
                    }
                    mmap.put("_atoms", _atoms);
                    mmap.put("_path", SV.newS((String)(_dbName + "." + _domainName)));
                    mmap.put("domain", _domainMap);
                }
            }
        }
        return list;
    }

    private void findAnnotationAtoms(Viewer vwr, String name, Lst<SV> _list, String key, BS bs) {
        if (_list == null) {
            return;
        }
        System.out.println("Checking " + name + " for " + key);
        Object data = vwr.extractProperty(_list, (Object)("[" + key + "]"), -1);
        Lst list = null;
        if (data instanceof Lst) {
            list = (Lst)data;
        } else if (data instanceof SV) {
            list = ((SV)data).getList();
        }
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Map mapping;
            Object o = list.get(i);
            Map map = mapping = o instanceof SV ? ((SV)o).getMap() : (Map)o;
            if (mapping == null) {
                return;
            }
            bs.or(this.setAnnotationAtoms(vwr, mapping, i));
        }
    }

    private BS setAnnotationAtoms(Viewer vwr, Map<String, SV> mapping, int i) {
        SV _atoms = mapping.get("_atoms");
        if (_atoms.tok != 10) {
            BS bs2 = vwr.getAtomBitSet(_atoms.value);
            if (i >= 0) {
                Logger.info((String)("#" + (i + 1) + " found " + bs2.cardinality() + " atoms for " + _atoms.value));
            }
            _atoms.tok = 10;
            _atoms.value = bs2;
        }
        return (BS)_atoms.value;
    }

    private boolean catalogUnit(Viewer viewer, float[][] vals, String unitID, float val, BS bsAtoms, int[] modelAtomIndices, Map<String, int[]> resMap, Map<String, Integer> atomMap, Map<String, Integer> modelMap) {
        boolean isRes;
        Integer im;
        String[] s = PT.split((String)(unitID + (vals == null ? "||||" : "|||")), (String)"|");
        if (s.length < 8 || s[1].length() == 0 || s[2].length() == 0 || s[3].length() == 0 || s[4].length() == 0) {
            return false;
        }
        String sm = s[1].length() == 0 ? "1" : s[1];
        int m = modelMap == null ? PT.parseInt((String)sm) - 1 : -1;
        Integer n = im = m >= 0 ? null : modelMap.get(sm);
        if (im != null) {
            m = im;
        }
        if (m >= modelAtomIndices.length) {
            return false;
        }
        String res = s[1] + "_" + viewer.getChainID(s[2], true) + "_" + s[4] + "_" + s[7].toLowerCase();
        int i0 = modelAtomIndices[m];
        boolean bl = isRes = atomMap == null || s[5].length() == 0;
        if (isRes) {
            int[] a2 = resMap.get(res);
            if (a2 != null) {
                int j = a2[1];
                int j0 = a2[0];
                while (--j >= j0) {
                    bsAtoms.set(i0 + j);
                    if (vals == null) continue;
                    float[] fArray = vals[m];
                    int n2 = j;
                    fArray[n2] = fArray[n2] + Math.abs(val);
                }
            }
        } else {
            String atom;
            Integer ia;
            if (s[5].charAt(0) == 'H') {
                s[5] = this.getAttachedAtomForPDBH(s[3], s[5]);
            }
            if ((ia = atomMap.get(atom = res + "_" + s[5] + "_" + s[6].toLowerCase())) != null) {
                int j = ia;
                bsAtoms.set(i0 + j);
                if (vals != null) {
                    float[] fArray = vals[m];
                    int n3 = j;
                    fArray[n3] = fArray[n3] + Math.abs(val);
                }
            }
        }
        return isRes;
    }

    public BS getAtomBits(Viewer vwr, String key, Object dbObj, Map<String, Object> annotationCache, int type, int modelIndex, BS bsModel) {
        BS bs;
        boolean doCache;
        if (dbObj == null) {
            return new BS();
        }
        boolean bl = doCache = !key.contains("NOCACHE");
        if (!doCache) {
            key = PT.rep((String)key, (String)"NOCACHE", (String)"").trim();
        }
        BS bS = bs = doCache ? (BS)annotationCache.get(key) : null;
        if (bs != null) {
            return bs;
        }
        bs = new BS();
        if (doCache) {
            annotationCache.put(key, bs);
        }
        try {
            Lst<SV> list = this.initializeAnnotation((SV)dbObj, type, modelIndex);
            int pt = key.toLowerCase().indexOf(" where ");
            String path = PT.rep((String)(pt < 0 ? key : key.substring(0, pt)), (String)" ", (String)"");
            String newKey = pt < 0 ? "" : key.substring(pt + 7).trim();
            path = path.indexOf(".") < 0 ? " _path like '" + path + "*'" : " _path='" + path + "'";
            newKey = "select * where " + (pt < 0 ? path : "(" + newKey + ") and (" + path + ")");
            Logger.info((String)("looking for " + newKey));
            this.findAnnotationAtoms(vwr, path, list, newKey, bs);
            bs.and(bsModel);
        }
        catch (Exception e) {
            System.out.println(e.toString() + " in AnnotationParser");
            bs.clearAll();
        }
        return bs;
    }

    public Lst<Float> getAtomValidation(Viewer vwr, String type, Atom atom) {
        int i = 0;
        int n = 0;
        Lst l = null;
        Map map = null;
        Lst list = null;
        try {
            int ia = atom.i;
            l = new Lst();
            list = ((SV)vwr.ms.getModelAuxiliaryInfo((int)atom.mi).get("validation")).mapGet("_list").getList();
            n = list.size();
            for (i = 0; i < n; ++i) {
                map = ((SV)list.get(i)).getMap();
                if (!((SV)map.get((Object)"_path")).value.equals(type) || !((BS)((SV)map.get((Object)"_atoms")).value).get(ia)) continue;
                SV v = (SV)map.get("value");
                l.addLast((Object)(v.tok == 3 ? (Float)v.value : Float.valueOf(v.asFloat())));
            }
            return l;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAnnotationInfo(Viewer vwr, SV a, String match, int type, int modelIndex) {
        boolean isDetail;
        SB sb = new SB();
        if ("".equals(match)) {
            match = null;
        }
        boolean bl = isDetail = match != null && (match.equals("all") || match.endsWith(" all"));
        if (isDetail) {
            Lst<SV> _list = this.initializeAnnotation(a, type, modelIndex);
            int i = _list.size();
            while (--i >= 0) {
                this.setAnnotationAtoms(vwr, ((SV)_list.get(i)).getMap(), -1);
            }
            match = match.substring(0, Math.max(0, match.length() - 4)).trim();
        }
        if ("".equals(match)) {
            match = null;
        }
        if (type == 1073742189 && !isDetail && match == null) {
            return a.mapGet("_note").asString();
        }
        boolean isMappingOnly = match != null && match.indexOf(".") >= 0 && match.indexOf(".*") < 0;
        match = PT.rep((String)match, (String)"*", (String)"");
        try {
            this.getAnnotationKVPairs(a, match, "", sb, "", isDetail, isMappingOnly, type);
        }
        catch (Exception e) {
            System.out.println(e.getStackTrace());
        }
        return sb.toString();
    }

    public String getAttachedAtomForPDBH(String group3, String name) {
        if (name.charAt(0) == 'H') {
            String a;
            if (pdbAtomForH == null) {
                pdbAtomForH = new Hashtable<String, String>();
                this.assignPDBH("", "N H H1 H2 H3 CB HB2 HB3 CD HD2 HD3 CG HG2 HG3 C2' H2'' H2' C5' H5'' H5' OXT HXT");
                int i = BioResolver.pdbBondInfo.length;
                while (--i >= 1) {
                    this.assignPDBH(Group.group3Names[i], BioResolver.pdbBondInfo[i]);
                }
            }
            if ((a = pdbAtomForH.get(name)) == null) {
                a = pdbAtomForH.get(group3 + name);
            }
            if (a != null) {
                return a;
            }
        }
        return name;
    }

    private void assignPDBH(String group3, String sNames) {
        String[] names = PT.getTokens((String)PT.rep((String)sNames, (String)"@", (String)" "));
        String a = null;
        for (String s : names) {
            if (s.charAt(0) != 'H') {
                a = s;
                continue;
            }
            s = group3 + s;
            if (s.indexOf("?") >= 0) {
                s = s.substring(0, s.length() - 1);
                pdbAtomForH.put(s + "1", a);
                pdbAtomForH.put(s + "2", a);
                pdbAtomForH.put(s + "3", a);
                continue;
            }
            pdbAtomForH.put(s, a);
        }
    }

    public void fixAtoms(int modelIndex, SV dbObj, BS bsAddedMask, int type, int margin) {
        Lst<SV> _list = this.initializeAnnotation(dbObj, type, modelIndex);
        int i = _list.size();
        while (--i >= 0) {
            Map m = ((SV)_list.get(i)).getMap();
            SV _atoms = (SV)m.get("_atoms");
            if (_atoms == null || _atoms.tok != 10) continue;
            BSUtil.shiftBits((BS)((BS)_atoms.value), (BS)bsAddedMask, (((SV)_list.get(i)).mapGet("_isres") != null ? 1 : 0) != 0, (int)(((BS)_atoms.value).length() + margin));
        }
    }

    public void getBasePairs(Viewer vwr, int modelIndex) {
    }

    public String calculateDSSRStructure(Viewer vwr, BS bsAtoms) {
        return null;
    }

    public String fixDSSRJSONMap(Map<String, Object> map) {
        return null;
    }

    public String getHBonds(ModelSet ms, int modelIndex, Lst<Bond> vHBonds, boolean doReport) {
        return null;
    }

    public void getAtomicDSSRData(ModelSet ms, int modelIndex, float[] dssrData, String dataType) {
    }

    public void setGroup1(ModelSet ms, int modelIndex) {
    }

    public P3[] getDSSRFrame(Map<String, Object> dssrNT) {
        return null;
    }
}

