/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Gradient;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class RadialGradient
extends Gradient {
    public static final String TAG_NAME = "radialgradient";
    float cx = 0.5f;
    float cy = 0.5f;
    boolean hasFocus = false;
    float fx = 0.0f;
    float fy = 0.0f;
    float r = 0.5f;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("cx"))) {
            this.cx = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("cy"))) {
            this.cy = styleAttribute.getFloatValueWithUnits();
        }
        this.hasFocus = false;
        if (this.getPres(styleAttribute.setName("fx"))) {
            this.fx = styleAttribute.getFloatValueWithUnits();
            this.hasFocus = true;
        }
        if (this.getPres(styleAttribute.setName("fy"))) {
            this.fy = styleAttribute.getFloatValueWithUnits();
            this.hasFocus = true;
        }
        if (this.getPres(styleAttribute.setName("r"))) {
            this.r = styleAttribute.getFloatValueWithUnits();
        }
    }

    @Override
    public Paint getPaint(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        RadialGradientPaint radialGradientPaint;
        Point2D.Float float_;
        MultipleGradientPaint.CycleMethod cycleMethod;
        switch (this.spreadMethod) {
            default: {
                cycleMethod = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                break;
            }
            case 1: {
                cycleMethod = MultipleGradientPaint.CycleMethod.REPEAT;
                break;
            }
            case 2: {
                cycleMethod = MultipleGradientPaint.CycleMethod.REFLECT;
            }
        }
        Point2D.Float float_2 = new Point2D.Float(this.cx, this.cy);
        Point2D.Float float_3 = float_ = this.hasFocus ? new Point2D.Float(this.fx, this.fy) : float_2;
        if (this.gradientUnits == 1) {
            radialGradientPaint = new RadialGradientPaint(float_2, this.r, float_, this.getStopFractions(), this.getStopColors(), cycleMethod, MultipleGradientPaint.ColorSpaceType.SRGB, this.gradientTransform);
        } else {
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(rectangle2D.getX(), rectangle2D.getY());
            affineTransform2.scale(rectangle2D.getWidth(), rectangle2D.getHeight());
            affineTransform2.concatenate(this.gradientTransform);
            radialGradientPaint = new RadialGradientPaint(float_2, this.r, float_, this.getStopFractions(), this.getStopColors(), cycleMethod, MultipleGradientPaint.ColorSpaceType.SRGB, affineTransform2);
        }
        return radialGradientPaint;
    }

    @Override
    public boolean updateTime(double d) throws SVGException {
        float f;
        boolean bl = super.updateTime(d);
        StyleAttribute styleAttribute = new StyleAttribute();
        boolean bl2 = false;
        if (this.getPres(styleAttribute.setName("cx")) && (f = styleAttribute.getFloatValueWithUnits()) != this.cx) {
            this.cx = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("cy")) && (f = styleAttribute.getFloatValueWithUnits()) != this.cy) {
            this.cy = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("fx")) && (f = styleAttribute.getFloatValueWithUnits()) != this.fx) {
            this.fx = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("fy")) && (f = styleAttribute.getFloatValueWithUnits()) != this.fy) {
            this.fy = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("r")) && (f = styleAttribute.getFloatValueWithUnits()) != this.r) {
            this.r = f;
            bl2 = true;
        }
        return bl;
    }
}

