/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary;

import java.util.Properties;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.config.OptionConverter;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuxiliaryCacheConfigurator {
    private static final Log log = LogFactory.getLog(AuxiliaryCacheConfigurator.class);
    public static final String ATTRIBUTE_PREFIX = ".attributes";
    public static final String CACHE_EVENT_LOGGER_PREFIX = ".cacheeventlogger";
    public static final String SERIALIZER_PREFIX = ".serializer";

    public static ICacheEventLogger parseCacheEventLogger(Properties properties, String string) {
        ICacheEventLogger iCacheEventLogger = null;
        String string2 = string + CACHE_EVENT_LOGGER_PREFIX;
        iCacheEventLogger = OptionConverter.instantiateByKey(properties, string2, null);
        if (iCacheEventLogger != null) {
            String string3 = string + CACHE_EVENT_LOGGER_PREFIX + ATTRIBUTE_PREFIX;
            PropertySetter.setProperties(iCacheEventLogger, properties, string3 + ".");
            if (log.isInfoEnabled()) {
                log.info("Using custom cache event logger [" + iCacheEventLogger + "] for auxiliary [" + string + "]");
            }
        } else if (log.isInfoEnabled()) {
            log.info("No cache event logger defined for auxiliary [" + string + "]");
        }
        return iCacheEventLogger;
    }

    public static IElementSerializer parseElementSerializer(Properties properties, String string) {
        IElementSerializer iElementSerializer = null;
        String string2 = string + SERIALIZER_PREFIX;
        iElementSerializer = OptionConverter.instantiateByKey(properties, string2, null);
        if (iElementSerializer != null) {
            String string3 = string + SERIALIZER_PREFIX + ATTRIBUTE_PREFIX;
            PropertySetter.setProperties(iElementSerializer, properties, string3 + ".");
            if (log.isInfoEnabled()) {
                log.info("Using custom element serializer [" + iElementSerializer + "] for auxiliary [" + string + "]");
            }
        } else {
            iElementSerializer = new StandardSerializer();
            if (log.isInfoEnabled()) {
                log.info("Using standard serializer [" + iElementSerializer + "] for auxiliary [" + string + "]");
            }
        }
        return iElementSerializer;
    }
}

