/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openstreetmap.gui.jmapviewer.AttributionSupport;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.events.JMVCommandEvent;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.JMapViewerEventListener;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class JMapViewer
extends JPanel
implements TileLoaderListener {
    private static final long serialVersionUID = 1L;
    public static boolean debug;
    public static boolean zoomReverseWheel;
    private static final Point[] move;
    public static final int MAX_ZOOM = 22;
    public static final int MIN_ZOOM = 0;
    protected transient List<MapMarker> mapMarkerList;
    protected transient List<MapRectangle> mapRectangleList;
    protected transient List<MapPolygon> mapPolygonList;
    protected boolean mapMarkersVisible;
    protected boolean mapRectanglesVisible;
    protected boolean mapPolygonsVisible;
    protected boolean tileGridVisible;
    protected boolean scrollWrapEnabled;
    protected transient TileController tileController;
    protected Point center;
    protected int zoom;
    protected JSlider zoomSlider;
    protected JButton zoomInButton;
    protected JButton zoomOutButton;
    protected ZOOM_BUTTON_STYLE zoomButtonStyle;
    protected transient TileSource tileSource;
    protected transient AttributionSupport attribution = new AttributionSupport();
    protected EventListenerList evtListenerList = new EventListenerList();

    public JMapViewer() {
        this(new MemoryTileCache());
        new DefaultMapController(this);
    }

    @Deprecated
    public JMapViewer(TileCache tileCache, int n) {
        this(tileCache);
    }

    public JMapViewer(TileCache tileCache) {
        this.tileSource = new OsmTileSource.Mapnik();
        this.tileController = new TileController(this.tileSource, tileCache, this);
        this.mapMarkerList = Collections.synchronizedList(new LinkedList());
        this.mapPolygonList = Collections.synchronizedList(new LinkedList());
        this.mapRectangleList = Collections.synchronizedList(new LinkedList());
        this.mapMarkersVisible = true;
        this.mapRectanglesVisible = true;
        this.mapPolygonsVisible = true;
        this.tileGridVisible = false;
        this.setLayout(null);
        this.initializeZoomSlider();
        this.setMinimumSize(new Dimension(this.tileSource.getTileSize(), this.tileSource.getTileSize()));
        this.setPreferredSize(new Dimension(400, 400));
        this.setDisplayPosition(new Coordinate(50.0, 9.0), 3);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return super.getToolTipText(mouseEvent);
    }

    protected void initializeZoomSlider() {
        ImageIcon imageIcon;
        this.zoomSlider = new JSlider(0, this.tileController.getTileSource().getMaxZoom());
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setBounds(10, 10, 30, 150);
        this.zoomSlider.setOpaque(false);
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JMapViewer.this.setZoom(JMapViewer.this.zoomSlider.getValue());
            }
        });
        this.zoomSlider.setFocusable(false);
        this.add(this.zoomSlider);
        int n = 18;
        URL uRL = JMapViewer.class.getResource("images/plus.png");
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
            this.zoomInButton = new JButton(imageIcon);
        } else {
            this.zoomInButton = new JButton("+");
            this.zoomInButton.setFont(new Font("sansserif", 1, 9));
            this.zoomInButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomInButton.setBounds(4, 155, n, n);
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMapViewer.this.zoomIn();
            }
        });
        this.zoomInButton.setFocusable(false);
        this.add(this.zoomInButton);
        uRL = JMapViewer.class.getResource("images/minus.png");
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
            this.zoomOutButton = new JButton(imageIcon);
        } else {
            this.zoomOutButton = new JButton("-");
            this.zoomOutButton.setFont(new Font("sansserif", 1, 9));
            this.zoomOutButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomOutButton.setBounds(8 + n, 155, n, n);
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMapViewer.this.zoomOut();
            }
        });
        this.zoomOutButton.setFocusable(false);
        this.add(this.zoomOutButton);
    }

    public void setDisplayPosition(ICoordinate iCoordinate, int n) {
        this.setDisplayPosition(new Point(this.getWidth() / 2, this.getHeight() / 2), iCoordinate, n);
    }

    public void setDisplayPosition(Point point, ICoordinate iCoordinate, int n) {
        Point point2 = this.tileSource.latLonToXY(iCoordinate, n);
        this.setDisplayPosition(point, point2.x, point2.y, n);
    }

    public void setDisplayPosition(int n, int n2, int n3) {
        this.setDisplayPosition(new Point(this.getWidth() / 2, this.getHeight() / 2), n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayPosition(Point point, int n, int n2, int n3) {
        if (n3 > this.tileController.getTileSource().getMaxZoom() || n3 < 0) {
            return;
        }
        Point point2 = new Point();
        point2.x = n - point.x + this.getWidth() / 2;
        point2.y = n2 - point.y + this.getHeight() / 2;
        this.center = point2;
        this.setIgnoreRepaint(true);
        try {
            int n4 = this.zoom;
            this.zoom = n3;
            if (n4 != n3) {
                this.zoomChanged(n4);
            }
            if (this.zoomSlider.getValue() != n3) {
                this.zoomSlider.setValue(n3);
            }
        }
        finally {
            this.setIgnoreRepaint(false);
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setDisplayToFitMapElements(boolean bl, boolean bl2, boolean bl3) {
        void var12_20;
        void var14_28;
        int n;
        Object object;
        JMapViewer jMapViewer;
        int n2 = 0;
        if (bl && this.mapMarkerList != null) {
            n2 += this.mapMarkerList.size();
        }
        if (bl2 && this.mapRectangleList != null) {
            n2 += this.mapRectangleList.size();
        }
        if (bl3 && this.mapPolygonList != null) {
            n2 += this.mapPolygonList.size();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = this.tileController.getTileSource().getMaxZoom();
        if (bl && this.mapMarkerList != null) {
            jMapViewer = this;
            synchronized (jMapViewer) {
                for (MapMarker mapObject : this.mapMarkerList) {
                    if (!mapObject.isVisible()) continue;
                    object = this.tileSource.latLonToXY(mapObject.getCoordinate(), n7);
                    n5 = Math.max(n5, ((Point)object).x);
                    n6 = Math.max(n6, ((Point)object).y);
                    n3 = Math.min(n3, ((Point)object).x);
                    n4 = Math.min(n4, ((Point)object).y);
                }
            }
        }
        if (bl2 && this.mapRectangleList != null) {
            jMapViewer = this;
            synchronized (jMapViewer) {
                for (MapRectangle mapRectangle : this.mapRectangleList) {
                    if (!mapRectangle.isVisible()) continue;
                    object = this.tileSource.latLonToXY(mapRectangle.getBottomRight(), n7);
                    Point point = this.tileSource.latLonToXY(mapRectangle.getTopLeft(), n7);
                    n5 = Math.max(n5, ((Point)object).x);
                    n6 = Math.max(n6, point.y);
                    n3 = Math.min(n3, point.x);
                    n4 = Math.min(n4, ((Point)object).y);
                }
            }
        }
        if (bl3 && this.mapPolygonList != null) {
            jMapViewer = this;
            synchronized (jMapViewer) {
                for (MapPolygon mapPolygon : this.mapPolygonList) {
                    if (!mapPolygon.isVisible()) continue;
                    for (ICoordinate iCoordinate : mapPolygon.getPoints()) {
                        Point point = this.tileSource.latLonToXY(iCoordinate, n7);
                        n5 = Math.max(n5, point.x);
                        n6 = Math.max(n6, point.y);
                        n3 = Math.min(n3, point.x);
                        n4 = Math.min(n4, point.y);
                    }
                }
            }
        }
        int n8 = Math.max(0, this.getHeight());
        int n9 = Math.max(0, this.getWidth());
        int n10 = n7;
        int n11 = n6 - n4;
        for (n = n5 - n3; n > n9 || var14_28 > n8; n >>= 1, var14_28 >>= 1) {
            --var12_20;
        }
        n = n3 + (n5 - n3) / 2;
        int n12 = n4 + (n6 - n4) / 2;
        int n13 = 1 << n7 - var12_20;
        int n14 = n12 / n13;
        this.setDisplayPosition(n /= n13, n14, (int)var12_20);
    }

    public void setDisplayToFitMapMarkers() {
        this.setDisplayToFitMapElements(true, false, false);
    }

    public void setDisplayToFitMapRectangles() {
        this.setDisplayToFitMapElements(false, true, false);
    }

    public void setDisplayToFitMapPolygons() {
        this.setDisplayToFitMapElements(false, false, true);
    }

    public Point getCenter() {
        return this.center;
    }

    public void setCenter(Point point) {
        this.center = point;
    }

    public ICoordinate getPosition() {
        return this.tileSource.xyToLatLon(this.center, this.zoom);
    }

    public ICoordinate getPosition(Point point) {
        return this.getPosition(point.x, point.y);
    }

    public ICoordinate getPosition(int n, int n2) {
        int n3 = this.center.x + n - this.getWidth() / 2;
        int n4 = this.center.y + n2 - this.getHeight() / 2;
        return this.tileSource.xyToLatLon(n3, n4, this.zoom);
    }

    public Point getMapPosition(double d, double d2, boolean bl) {
        Point point = this.tileSource.latLonToXY(d, d2, this.zoom);
        point.translate(-(this.center.x - this.getWidth() / 2), -(this.center.y - this.getHeight() / 2));
        if (bl && (point.x < 0 || point.y < 0 || point.x > this.getWidth() || point.y > this.getHeight())) {
            return null;
        }
        return point;
    }

    public Point getMapPosition(double d, double d2) {
        return this.getMapPosition(d, d2, true);
    }

    public Integer getLatOffset(double d, double d2, double d3, boolean bl) {
        Point point = this.tileSource.latLonToXY(d + d3, d2, this.zoom);
        int n = point.y - (this.center.y - this.getHeight() / 2);
        if (bl && (n < 0 || n > this.getHeight())) {
            return null;
        }
        return n;
    }

    public Integer getRadius(MapMarker mapMarker, Point point) {
        if (mapMarker.getMarkerStyle() == MapMarker.STYLE.FIXED) {
            return (int)mapMarker.getRadius();
        }
        if (point != null) {
            Integer n = this.getLatOffset(mapMarker.getLat(), mapMarker.getLon(), mapMarker.getRadius(), false);
            n = n == null ? null : Integer.valueOf(point.y - n);
            return n;
        }
        return null;
    }

    public Point getMapPosition(Coordinate coordinate) {
        if (coordinate != null) {
            return this.getMapPosition(coordinate.getLat(), coordinate.getLon());
        }
        return null;
    }

    public Point getMapPosition(ICoordinate iCoordinate, boolean bl) {
        if (iCoordinate != null) {
            return this.getMapPosition(iCoordinate.getLat(), iCoordinate.getLon(), bl);
        }
        return null;
    }

    public double getMeterPerPixel() {
        Point point = new Point(5, 5);
        Point point2 = new Point(this.getWidth() / 2, this.getHeight() / 2);
        double d = point2.distance(point);
        ICoordinate iCoordinate = this.getPosition(point);
        ICoordinate iCoordinate2 = this.getPosition(point2);
        double d2 = this.tileSource.getDistance(iCoordinate.getLat(), iCoordinate.getLon(), iCoordinate2.getLat(), iCoordinate2.getLon());
        return d2 / d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        boolean bl;
        super.paintComponent(graphics);
        int n2 = 0;
        int n3 = this.tileSource.getTileSize();
        int n4 = this.center.x / n3;
        int n5 = this.center.y / n3;
        int n6 = this.center.x % n3;
        int n7 = this.center.y % n3;
        int n8 = this.getWidth() / 2;
        int n9 = this.getHeight() / 2;
        int n10 = n8 - n6;
        int n11 = n9 - n7;
        int n12 = n6;
        int n13 = n3 - n6;
        int n14 = n7;
        int n15 = n3 - n7;
        boolean bl2 = n12 < n13;
        boolean bl3 = bl = n14 < n15;
        n2 = bl ? (bl2 ? 2 : 3) : (bl2 ? 1 : 0);
        int n16 = -n3;
        int n17 = -n3;
        int n18 = this.getWidth();
        int n19 = this.getHeight();
        int n20 = 1 << this.zoom;
        boolean bl4 = true;
        int n21 = 0;
        while (bl4) {
            bl4 = false;
            for (n = 0; n < 4; ++n) {
                if (n % 2 == 0) {
                    ++n21;
                }
                for (int i = 0; i < n21; ++i) {
                    Object object;
                    if (n16 <= n10 && n10 <= n18 && n17 <= n11 && n11 <= n19) {
                        if (this.scrollWrapEnabled) {
                            int n22 = (n4 % n20 + n20) % n20;
                            object = this.tileController.getTile(n22, n5, this.zoom);
                        } else {
                            object = this.tileController.getTile(n4, n5, this.zoom);
                        }
                        if (object != null) {
                            ((Tile)object).paint(graphics, n10, n11, n3, n3);
                            if (this.tileGridVisible) {
                                graphics.drawRect(n10, n11, n3, n3);
                            }
                        }
                        bl4 = true;
                    }
                    object = move[n2];
                    n10 += ((Point)object).x * n3;
                    n11 += ((Point)object).y * n3;
                    n4 += ((Point)object).x;
                    n5 += ((Point)object).y;
                }
                n2 = (n2 + 1) % move.length;
            }
        }
        n = n3 << this.zoom;
        if (this.scrollWrapEnabled) {
            graphics.drawLine(0, n9 - this.center.y, this.getWidth(), n9 - this.center.y);
            graphics.drawLine(0, n9 - this.center.y + n, this.getWidth(), n9 - this.center.y + n);
        } else {
            graphics.drawRect(n8 - this.center.x, n9 - this.center.y, n, n);
        }
        if (this.scrollWrapEnabled) {
            this.center.x %= n;
        }
        if (this.mapPolygonsVisible && this.mapPolygonList != null) {
            JMapViewer jMapViewer = this;
            synchronized (jMapViewer) {
                for (MapPolygon mapPolygon : this.mapPolygonList) {
                    if (!mapPolygon.isVisible()) continue;
                    this.paintPolygon(graphics, mapPolygon);
                }
            }
        }
        if (this.mapRectanglesVisible && this.mapRectangleList != null) {
            JMapViewer jMapViewer = this;
            synchronized (jMapViewer) {
                for (MapRectangle mapRectangle : this.mapRectangleList) {
                    if (!mapRectangle.isVisible()) continue;
                    this.paintRectangle(graphics, mapRectangle);
                }
            }
        }
        if (this.mapMarkersVisible && this.mapMarkerList != null) {
            JMapViewer jMapViewer = this;
            synchronized (jMapViewer) {
                for (MapMarker mapMarker : this.mapMarkerList) {
                    if (!mapMarker.isVisible()) continue;
                    this.paintMarker(graphics, mapMarker);
                }
            }
        }
        this.attribution.paintAttribution(graphics, this.getWidth(), this.getHeight(), this.getPosition(0, 0), this.getPosition(this.getWidth(), this.getHeight()), this.zoom, this);
    }

    protected void paintMarker(Graphics graphics, MapMarker mapMarker) {
        Point point = this.getMapPosition(mapMarker.getLat(), mapMarker.getLon(), mapMarker.getMarkerStyle() == MapMarker.STYLE.FIXED);
        Integer n = this.getRadius(mapMarker, point);
        if (this.scrollWrapEnabled) {
            int n2;
            int n3 = this.tileSource.getTileSize();
            int n4 = n3 << this.zoom;
            if (point == null) {
                point = this.getMapPosition(mapMarker.getLat(), mapMarker.getLon(), false);
                n = this.getRadius(mapMarker, point);
            }
            mapMarker.paint(graphics, point, n);
            int n5 = n2 = point.x;
            while ((n5 -= n4) >= -15) {
                point.x = n5;
                mapMarker.paint(graphics, point, n);
            }
            n5 = n2;
            while ((n5 += n4) <= this.getWidth() + 15) {
                point.x = n5;
                mapMarker.paint(graphics, point, n);
            }
        } else if (point != null) {
            mapMarker.paint(graphics, point, n);
        }
    }

    protected void paintRectangle(Graphics graphics, MapRectangle mapRectangle) {
        Coordinate coordinate = mapRectangle.getTopLeft();
        Coordinate coordinate2 = mapRectangle.getBottomRight();
        if (coordinate != null && coordinate2 != null) {
            Point point = this.getMapPosition(coordinate, false);
            Point point2 = this.getMapPosition(coordinate2, false);
            if (point != null && point2 != null) {
                mapRectangle.paint(graphics, point, point2);
                if (this.scrollWrapEnabled) {
                    int n;
                    int n2;
                    int n3 = this.tileSource.getTileSize();
                    int n4 = n3 << this.zoom;
                    int n5 = n2 = point.x;
                    int n6 = n = point2.x;
                    while ((n6 -= n4) >= 0) {
                        point.x = n5 -= n4;
                        point2.x = n6;
                        mapRectangle.paint(graphics, point, point2);
                    }
                    n5 = n2;
                    n6 = n;
                    while ((n5 += n4) <= this.getWidth()) {
                        point.x = n5;
                        point2.x = n6 += n4;
                        mapRectangle.paint(graphics, point, point2);
                    }
                }
            }
        }
    }

    protected void paintPolygon(Graphics graphics, MapPolygon mapPolygon) {
        List<? extends ICoordinate> list = mapPolygon.getPoints();
        if (list != null && list.size() >= 3) {
            Cloneable cloneable;
            LinkedList<Point> linkedList = new LinkedList<Point>();
            for (ICoordinate iCoordinate : list) {
                cloneable = this.getMapPosition(iCoordinate, false);
                if (cloneable == null) {
                    return;
                }
                linkedList.add((Point)cloneable);
            }
            mapPolygon.paint(graphics, linkedList);
            if (this.scrollWrapEnabled) {
                Point point;
                Iterator iterator;
                int n = this.tileSource.getTileSize();
                int n2 = n << this.zoom;
                cloneable = new LinkedList<Point>(linkedList);
                boolean bl = true;
                while (bl) {
                    iterator = cloneable.iterator();
                    while (iterator.hasNext()) {
                        point = (Point)iterator.next();
                        point.x -= n2;
                        if (point.x >= 0) continue;
                        bl = false;
                    }
                    mapPolygon.paint(graphics, (List<Point>)((Object)cloneable));
                }
                cloneable = new LinkedList<Point>(linkedList);
                bl = true;
                while (bl) {
                    iterator = cloneable.iterator();
                    while (iterator.hasNext()) {
                        point = (Point)iterator.next();
                        point.x += n2;
                        if (point.x <= this.getWidth()) continue;
                        bl = false;
                    }
                    mapPolygon.paint(graphics, (List<Point>)((Object)cloneable));
                }
            }
        }
    }

    public void moveMap(int n, int n2) {
        this.tileController.cancelOutstandingJobs();
        this.center.x += n;
        this.center.y += n2;
        this.repaint();
        this.fireJMVEvent(new JMVCommandEvent(JMVCommandEvent.COMMAND.MOVE, this));
    }

    public int getZoom() {
        return this.zoom;
    }

    public void zoomIn() {
        this.setZoom(this.zoom + 1);
    }

    public void zoomIn(Point point) {
        this.setZoom(this.zoom + 1, point);
    }

    public void zoomOut() {
        this.setZoom(this.zoom - 1);
    }

    public void zoomOut(Point point) {
        this.setZoom(this.zoom - 1, point);
    }

    public void setZoom(int n, Point point) {
        if (n > this.tileController.getTileSource().getMaxZoom() || n < this.tileController.getTileSource().getMinZoom() || n == this.zoom) {
            return;
        }
        ICoordinate iCoordinate = this.getPosition(point);
        this.tileController.cancelOutstandingJobs();
        this.setDisplayPosition(point, iCoordinate, n);
        this.fireJMVEvent(new JMVCommandEvent(JMVCommandEvent.COMMAND.ZOOM, this));
    }

    public void setZoom(int n) {
        this.setZoom(n, new Point(this.getWidth() / 2, this.getHeight() / 2));
    }

    protected void zoomChanged(int n) {
        this.zoomSlider.setToolTipText("Zoom level " + this.zoom);
        this.zoomInButton.setToolTipText("Zoom to level " + (this.zoom + 1));
        this.zoomOutButton.setToolTipText("Zoom to level " + (this.zoom - 1));
        this.zoomOutButton.setEnabled(this.zoom > this.tileController.getTileSource().getMinZoom());
        this.zoomInButton.setEnabled(this.zoom < this.tileController.getTileSource().getMaxZoom());
    }

    public boolean isTileGridVisible() {
        return this.tileGridVisible;
    }

    public void setTileGridVisible(boolean bl) {
        this.tileGridVisible = bl;
        this.repaint();
    }

    public boolean getMapMarkersVisible() {
        return this.mapMarkersVisible;
    }

    public void setMapMarkerVisible(boolean bl) {
        this.mapMarkersVisible = bl;
        this.repaint();
    }

    public void setMapMarkerList(List<MapMarker> list) {
        this.mapMarkerList = list;
        this.repaint();
    }

    public List<MapMarker> getMapMarkerList() {
        return this.mapMarkerList;
    }

    public void setMapRectangleList(List<MapRectangle> list) {
        this.mapRectangleList = list;
        this.repaint();
    }

    public List<MapRectangle> getMapRectangleList() {
        return this.mapRectangleList;
    }

    public void setMapPolygonList(List<MapPolygon> list) {
        this.mapPolygonList = list;
        this.repaint();
    }

    public List<MapPolygon> getMapPolygonList() {
        return this.mapPolygonList;
    }

    public void addMapMarker(MapMarker mapMarker) {
        this.mapMarkerList.add(mapMarker);
        this.repaint();
    }

    public void removeMapMarker(MapMarker mapMarker) {
        this.mapMarkerList.remove(mapMarker);
        this.repaint();
    }

    public void removeAllMapMarkers() {
        this.mapMarkerList.clear();
        this.repaint();
    }

    public void addMapRectangle(MapRectangle mapRectangle) {
        this.mapRectangleList.add(mapRectangle);
        this.repaint();
    }

    public void removeMapRectangle(MapRectangle mapRectangle) {
        this.mapRectangleList.remove(mapRectangle);
        this.repaint();
    }

    public void removeAllMapRectangles() {
        this.mapRectangleList.clear();
        this.repaint();
    }

    public void addMapPolygon(MapPolygon mapPolygon) {
        this.mapPolygonList.add(mapPolygon);
        this.repaint();
    }

    public void removeMapPolygon(MapPolygon mapPolygon) {
        this.mapPolygonList.remove(mapPolygon);
        this.repaint();
    }

    public void removeAllMapPolygons() {
        this.mapPolygonList.clear();
        this.repaint();
    }

    public void setZoomContolsVisible(boolean bl) {
        this.zoomSlider.setVisible(bl);
        this.zoomInButton.setVisible(bl);
        this.zoomOutButton.setVisible(bl);
    }

    public boolean getZoomControlsVisible() {
        return this.zoomSlider.isVisible();
    }

    public void setTileSource(TileSource tileSource) {
        if (tileSource.getMaxZoom() > 22) {
            throw new RuntimeException("Maximum zoom level too high");
        }
        if (tileSource.getMinZoom() < 0) {
            throw new RuntimeException("Minimum zoom level too low");
        }
        ICoordinate iCoordinate = this.getPosition();
        this.tileSource = tileSource;
        this.tileController.setTileSource(tileSource);
        this.zoomSlider.setMinimum(tileSource.getMinZoom());
        this.zoomSlider.setMaximum(tileSource.getMaxZoom());
        this.tileController.cancelOutstandingJobs();
        if (this.zoom > tileSource.getMaxZoom()) {
            this.setZoom(tileSource.getMaxZoom());
        }
        this.attribution.initialize(tileSource);
        this.setDisplayPosition(iCoordinate, this.zoom);
        this.repaint();
    }

    @Override
    public void tileLoadingFinished(Tile tile, boolean bl) {
        tile.setLoaded(bl);
        this.repaint();
    }

    public boolean isMapRectanglesVisible() {
        return this.mapRectanglesVisible;
    }

    public void setMapRectanglesVisible(boolean bl) {
        this.mapRectanglesVisible = bl;
        this.repaint();
    }

    public boolean isMapPolygonsVisible() {
        return this.mapPolygonsVisible;
    }

    public void setMapPolygonsVisible(boolean bl) {
        this.mapPolygonsVisible = bl;
        this.repaint();
    }

    public boolean isScrollWrapEnabled() {
        return this.scrollWrapEnabled;
    }

    public void setScrollWrapEnabled(boolean bl) {
        this.scrollWrapEnabled = bl;
        this.repaint();
    }

    public ZOOM_BUTTON_STYLE getZoomButtonStyle() {
        return this.zoomButtonStyle;
    }

    public void setZoomButtonStyle(ZOOM_BUTTON_STYLE zOOM_BUTTON_STYLE) {
        this.zoomButtonStyle = zOOM_BUTTON_STYLE;
        if (this.zoomSlider == null || this.zoomInButton == null || this.zoomOutButton == null) {
            return;
        }
        switch (zOOM_BUTTON_STYLE) {
            case VERTICAL: {
                this.zoomSlider.setBounds(10, 27, 30, 150);
                this.zoomInButton.setBounds(14, 8, 20, 20);
                this.zoomOutButton.setBounds(14, 176, 20, 20);
                break;
            }
            default: {
                this.zoomSlider.setBounds(10, 10, 30, 150);
                this.zoomInButton.setBounds(4, 155, 18, 18);
                this.zoomOutButton.setBounds(26, 155, 18, 18);
            }
        }
        this.repaint();
    }

    public TileController getTileController() {
        return this.tileController;
    }

    public TileCache getTileCache() {
        return this.tileController.getTileCache();
    }

    public void setTileLoader(TileLoader tileLoader) {
        this.tileController.setTileLoader(tileLoader);
    }

    public AttributionSupport getAttribution() {
        return this.attribution;
    }

    public void addJMVListener(JMapViewerEventListener jMapViewerEventListener) {
        this.evtListenerList.add(JMapViewerEventListener.class, jMapViewerEventListener);
    }

    public void removeJMVListener(JMapViewerEventListener jMapViewerEventListener) {
        this.evtListenerList.remove(JMapViewerEventListener.class, jMapViewerEventListener);
    }

    private void fireJMVEvent(JMVCommandEvent jMVCommandEvent) {
        Object[] objectArray = this.evtListenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != JMapViewerEventListener.class) continue;
            ((JMapViewerEventListener)objectArray[i + 1]).processCommand(jMVCommandEvent);
        }
    }

    static {
        move = new Point[]{new Point(1, 0), new Point(0, 1), new Point(-1, 0), new Point(0, -1)};
    }

    public static enum ZOOM_BUTTON_STYLE {
        HORIZONTAL,
        VERTICAL;

    }
}

