/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import org.openstreetmap.gui.jmapviewer.TileXY;

public class TileRange {
    protected int minX;
    protected int maxX;
    protected int minY;
    protected int maxY;
    protected int zoom;

    protected TileRange() {
    }

    public TileRange(TileXY tileXY, TileXY tileXY2, int n) {
        this.minX = (int)Math.floor(Math.min(tileXY.getX(), tileXY2.getX()));
        this.minY = (int)Math.floor(Math.min(tileXY.getY(), tileXY2.getY()));
        this.maxX = (int)Math.ceil(Math.max(tileXY.getX(), tileXY2.getX()));
        this.maxY = (int)Math.ceil(Math.max(tileXY.getY(), tileXY2.getY()));
        this.zoom = n;
    }

    public TileRange(TileRange tileRange) {
        this.minX = tileRange.minX;
        this.minY = tileRange.minY;
        this.maxX = tileRange.maxX;
        this.maxY = tileRange.maxY;
        this.zoom = tileRange.zoom;
    }

    protected double tilesSpanned() {
        return Math.sqrt(1.0 * (double)this.size());
    }

    public int size() {
        int n = this.maxX - this.minX + 1;
        int n2 = this.maxY - this.minY + 1;
        return n * n2;
    }
}

