/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.io.IOException;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;

public class OsmTileSource {

    public static abstract class TransportMap
    extends AbstractOsmTileSource {
        private static final String PATTERN = "https://%s.tile.thunderforest.com/transport";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int serverNum;

        public TransportMap() {
            super("OSM Transport Map", PATTERN, "osmtransportmap");
        }

        protected abstract String getApiKey();

        @Override
        public String getBaseUrl() {
            String string = String.format(this.baseUrl, SERVER[this.serverNum]);
            this.serverNum = (this.serverNum + 1) % SERVER.length;
            return string;
        }

        @Override
        public int getMaxZoom() {
            return 18;
        }

        @Override
        public String getTileUrl(int n, int n2, int n3) throws IOException {
            return this.getBaseUrl() + this.getTilePath(n, n2, n3) + "?apikey=" + this.getApiKey();
        }

        @Override
        public String getAttributionText(int n, ICoordinate iCoordinate, ICoordinate iCoordinate2) {
            return "Maps \u00a9 Thunderforest, Data \u00a9 OpenStreetMap contributors";
        }

        @Override
        public String getAttributionLinkURL() {
            return "http://www.thunderforest.com/";
        }
    }

    public static class CycleMap
    extends AbstractOsmTileSource {
        private static final String PATTERN = "http://%s.tile.opencyclemap.org/cycle";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int serverNum;

        public CycleMap() {
            super("Cyclemap", PATTERN, "opencyclemap");
        }

        @Override
        public String getBaseUrl() {
            String string = String.format(this.baseUrl, SERVER[this.serverNum]);
            this.serverNum = (this.serverNum + 1) % SERVER.length;
            return string;
        }

        @Override
        public int getMaxZoom() {
            return 18;
        }
    }

    public static class Mapnik
    extends AbstractOsmTileSource {
        private static final String PATTERN = "https://%s.tile.openstreetmap.org";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int serverNum;

        public Mapnik() {
            super("Mapnik", PATTERN, "MAPNIK");
        }

        @Override
        public String getBaseUrl() {
            String string = String.format(this.baseUrl, SERVER[this.serverNum]);
            this.serverNum = (this.serverNum + 1) % SERVER.length;
            return string;
        }
    }
}

