/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public final class AboutAction
extends JosmAction {
    public AboutAction() {
        super(I18n.tr("About", new Object[0]), "logo", I18n.tr("Display the about screen.", new Object[0]), Shortcut.registerShortcut("system:about", I18n.tr("About", new Object[0]), 112, 5005), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        Version version = Version.getInstance();
        JosmTextArea josmTextArea = new JosmTextArea();
        josmTextArea.setFont(GuiHelper.getMonospacedFont(josmTextArea));
        josmTextArea.setEditable(false);
        this.setTextFromResourceFile(josmTextArea, "/README");
        josmTextArea.setCaretPosition(0);
        JosmTextArea josmTextArea2 = new JosmTextArea();
        josmTextArea2.setFont(GuiHelper.getMonospacedFont(josmTextArea2));
        josmTextArea2.setEditable(false);
        josmTextArea2.setText(version.getReleaseAttributes());
        josmTextArea2.setCaretPosition(0);
        JosmTextArea josmTextArea3 = new JosmTextArea();
        josmTextArea3.setEditable(false);
        this.setTextFromResourceFile(josmTextArea3, "/CONTRIBUTION");
        josmTextArea3.setCaretPosition(0);
        JosmTextArea josmTextArea4 = new JosmTextArea();
        josmTextArea4.setEditable(false);
        this.setTextFromResourceFile(josmTextArea4, "/LICENSE");
        josmTextArea4.setCaretPosition(0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JMultilineLabel jMultilineLabel = new JMultilineLabel("<html><h1>JOSM \u2013 " + I18n.tr("Java OpenStreetMap Editor", new Object[0]) + "</h1><p style='font-size:75%'></p><p>" + I18n.tr("Version {0}", version.getVersionString()) + "</p><p style='font-size:50%'></p><p>" + I18n.tr("Last change at {0}", version.getTime()) + "</p><p style='font-size:50%'></p><p>" + I18n.tr("Java Version {0}", System.getProperty("java.version")) + "</p><p style='font-size:50%'></p></html>");
        jPanel.add((Component)jMultilineLabel, GBC.eol().fill(2).insets(10, 0, 0, 0));
        jPanel.add((Component)new JLabel(I18n.tr("Homepage", new Object[0])), GBC.std().insets(10, 0, 10, 0));
        jPanel.add((Component)new UrlLabel(Main.getJOSMWebsite(), 2), GBC.eol().fill(2));
        jPanel.add(GBC.glue(0, 5), GBC.eol());
        jTabbedPane.addTab(I18n.tr("Info", new Object[0]), jPanel);
        jTabbedPane.addTab(I18n.tr("Readme", new Object[0]), AboutAction.createScrollPane(josmTextArea));
        jTabbedPane.addTab(I18n.tr("Revision", new Object[0]), AboutAction.createScrollPane(josmTextArea2));
        jTabbedPane.addTab(I18n.tr("Contribution", new Object[0]), AboutAction.createScrollPane(josmTextArea3));
        jTabbedPane.addTab(I18n.tr("License", new Object[0]), AboutAction.createScrollPane(josmTextArea4));
        jTabbedPane.addTab(I18n.tr("Plugins", new Object[0]), new JScrollPane(PluginHandler.getInfoPanel()));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setPreferredSize(new Dimension(890, 300));
        jPanel2.add((Component)new JLabel("", ImageProvider.get("logo.svg", ImageProvider.ImageSizes.ABOUT_LOGO), 0), GBC.std().insets(0, 5, 0, 0));
        jPanel2.add((Component)jTabbedPane, GBC.std().fill());
        GuiHelper.prepareResizeableOptionPane(jPanel2, jPanel2.getPreferredSize());
        int n = new ExtendedDialog(Main.parent, I18n.tr("About JOSM...", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Report bug", new Object[0])).setButtonIcons("ok", "bug").setContent(jPanel2, false).showDialog().getValue();
        if (2 == n) {
            Main.main.menu.reportbug.actionPerformed(null);
        }
    }

    private void setTextFromResourceFile(JTextArea jTextArea, String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            AboutAction.displayErrorMessage(jTextArea, I18n.tr("Failed to locate resource ''{0}''.", string));
        } else {
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    jTextArea.append(string2 + '\n');
                }
            }
            catch (IOException iOException) {
                Main.warn(iOException);
                AboutAction.displayErrorMessage(jTextArea, I18n.tr("Failed to load resource ''{0}'', error is {1}.", string, iOException.toString()));
            }
        }
    }

    private static void displayErrorMessage(JTextArea jTextArea, String string) {
        Main.warn(string);
        jTextArea.setForeground(new Color(200, 0, 0));
        jTextArea.setText(string);
    }

    private static JScrollPane createScrollPane(JosmTextArea josmTextArea) {
        josmTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        josmTextArea.setOpaque(false);
        JScrollPane jScrollPane = new JScrollPane(josmTextArea);
        jScrollPane.setBorder(null);
        jScrollPane.setOpaque(false);
        return jScrollPane;
    }
}

