/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.preferences.AbstractSetting;
import org.openstreetmap.josm.data.preferences.SettingVisitor;

public class ListSetting
extends AbstractSetting<List<String>> {
    public ListSetting(List<String> list) {
        super(list);
        this.consistencyTest();
    }

    public static ListSetting create(Collection<String> collection) {
        return new ListSetting(collection == null ? null : Collections.unmodifiableList(new ArrayList<String>(collection)));
    }

    public ListSetting copy() {
        return ListSetting.create((Collection)this.value);
    }

    private void consistencyTest() {
        if (this.value != null && ((List)this.value).contains(null)) {
            throw new IllegalArgumentException("Error: Null as list element in preference setting");
        }
    }

    @Override
    public void visit(SettingVisitor settingVisitor) {
        settingVisitor.visit(this);
    }

    public ListSetting getNullInstance() {
        return new ListSetting(null);
    }
}

