/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class PolarStereographic
extends AbstractProj {
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double ITERATION_TOLERANCE = 1.0E-10;
    private static final double EPSILON = 1.0E-8;
    private double k0;
    boolean southPole;

    @Override
    public String getName() {
        return I18n.tr("Polar Stereographic", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "stere";
    }

    @Override
    public void initialize(ProjParameters projParameters) throws ProjectionConfigurationException {
        super.initialize(projParameters);
        if (projParameters.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        if (projParameters.lat0 != 90.0 && projParameters.lat0 != -90.0) {
            throw new ProjectionConfigurationException(I18n.tr("Polar Stereographic: Parameter ''{0}'' must be 90 or -90.", "lat_0"));
        }
        double d = projParameters.lat_ts == null ? (projParameters.lat0 < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Utils.toRadians(projParameters.lat_ts);
        this.southPole = d < 0.0;
        double d2 = Math.abs(d);
        if (Math.abs(d2 - 1.5707963267948966) >= 1.0E-8) {
            double d3 = Math.sin(d2);
            this.k0 = this.msfn(d3, Math.cos(d2)) / this.tsfn(d2, d3);
        } else {
            this.k0 = 2.0 / Math.sqrt(Math.pow(1.0 + this.e, 1.0 + this.e) * Math.pow(1.0 - this.e, 1.0 - this.e));
        }
    }

    @Override
    public double[] project(double d, double d2) {
        double d3 = Math.sin(d);
        double d4 = Math.cos(d2);
        double d5 = Math.sin(d2);
        if (this.southPole) {
            double d6 = this.k0 * this.tsfn(-d, -d3);
            d2 = d6 * d5;
            d = d6 * d4;
        } else {
            double d7 = this.k0 * this.tsfn(d, d3);
            d2 = d7 * d5;
            d = -d7 * d4;
        }
        return new double[]{d2, d};
    }

    @Override
    public double[] invproject(double d, double d2) {
        double d3;
        double d4;
        block2: {
            d4 = Math.hypot(d, d2);
            if (this.southPole) {
                d2 = -d2;
            }
            double d5 = d4 / this.k0;
            double d6 = this.e / 2.0;
            double d7 = 0.0;
            int n = 15;
            do {
                double d8;
                if (Math.abs((d3 = 1.5707963267948966 - 2.0 * Math.atan(d5 * Math.pow((1.0 - (d8 = this.e * Math.sin(d7))) / (1.0 + d8), d6))) - d7) < 1.0E-10) break block2;
                d7 = d3;
            } while (--n >= 0);
            throw new IllegalStateException("no convergence for x=" + d + ", y=" + d2);
        }
        d = Math.abs(d4) < 1.0E-8 ? 0.0 : Math.atan2(d, -d2);
        d2 = this.southPole ? -d3 : d3;
        return new double[]{d2, d};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        if (this.southPole) {
            return new Bounds(-90.0, -180.0, 60.0, 180.0, false);
        }
        return new Bounds(-60.0, -180.0, 90.0, 180.0, false);
    }
}

