/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.data.validation.util.MultipleNameVisitor;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class TestError
implements Comparable<TestError> {
    private boolean ignored;
    private final Severity severity;
    private final String message;
    private final String description;
    private final String descriptionEn;
    private final Collection<? extends OsmPrimitive> primitives;
    private final Collection<?> highlighted;
    private final Test tester;
    private final int code;
    private boolean selected;
    private final Supplier<Command> fixingCommand;

    public static Builder builder(Test test, Severity severity, int n) {
        return new Builder(test, severity, n);
    }

    TestError(Builder builder) {
        this.tester = builder.tester;
        this.severity = builder.severity;
        this.message = builder.message;
        this.description = builder.description;
        this.descriptionEn = builder.descriptionEn;
        this.primitives = builder.primitives;
        this.highlighted = builder.highlighted;
        this.code = builder.code;
        this.fixingCommand = builder.fixingCommand;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<? extends OsmPrimitive> getPrimitives() {
        return Collections.unmodifiableCollection(this.primitives);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getIgnoreState() {
        TreeSet<String> treeSet = new TreeSet<String>();
        StringBuilder stringBuilder = new StringBuilder(this.getIgnoreSubGroup());
        for (OsmPrimitive object : this.primitives) {
            if (object.isNew()) {
                return null;
            }
            String string = "u";
            if (object instanceof Way) {
                string = "w";
            } else if (object instanceof Relation) {
                string = "r";
            } else if (object instanceof Node) {
                string = "n";
            }
            treeSet.add(string + '_' + object.getId());
        }
        for (String string : treeSet) {
            stringBuilder.append(':').append(string);
        }
        return stringBuilder.toString();
    }

    public String getIgnoreSubGroup() {
        String string = this.getIgnoreGroup();
        if (this.descriptionEn != null) {
            string = string + '_' + this.descriptionEn;
        }
        return string;
    }

    public String getIgnoreGroup() {
        return Integer.toString(this.code);
    }

    public void setIgnored(boolean bl) {
        this.ignored = bl;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public Test getTester() {
        return this.tester;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isFixable() {
        return this.fixingCommand != null || this.tester != null && this.tester.isFixable(this);
    }

    public Command getFix() {
        Command command;
        Command command2 = command = this.fixingCommand != null ? this.fixingCommand.get() : null;
        if (command != null) {
            return command;
        }
        if (this.tester == null || !this.tester.isFixable(this) || this.primitives.isEmpty()) {
            return null;
        }
        return this.tester.fixError(this);
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void visitHighlighted(ValidatorVisitor validatorVisitor) {
        for (Object obj : this.highlighted) {
            if (obj instanceof OsmPrimitive) {
                validatorVisitor.visit((OsmPrimitive)obj);
                continue;
            }
            if (obj instanceof WaySegment) {
                validatorVisitor.visit((WaySegment)obj);
                continue;
            }
            if (!(obj instanceof List)) continue;
            validatorVisitor.visit((List)obj);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Collection<?> getHighlighted() {
        return Collections.unmodifiableCollection(this.highlighted);
    }

    @Override
    public int compareTo(TestError testError) {
        if (this.equals(testError)) {
            return 0;
        }
        MultipleNameVisitor multipleNameVisitor = new MultipleNameVisitor();
        MultipleNameVisitor multipleNameVisitor2 = new MultipleNameVisitor();
        multipleNameVisitor.visit(this.getPrimitives());
        multipleNameVisitor2.visit(testError.getPrimitives());
        return AlphanumComparator.getInstance().compare(multipleNameVisitor.toString(), multipleNameVisitor2.toString());
    }

    public String toString() {
        return "TestError [tester=" + this.tester + ", code=" + this.code + ", message=" + this.message + ']';
    }

    public static final class Builder {
        private final Test tester;
        private final Severity severity;
        private final int code;
        private String message;
        private String description;
        private String descriptionEn;
        private Collection<? extends OsmPrimitive> primitives;
        private Collection<?> highlighted;
        private Supplier<Command> fixingCommand;

        Builder(Test test, Severity severity, int n) {
            this.tester = test;
            this.severity = severity;
            this.code = n;
        }

        public Builder message(String string) {
            this.message = string;
            return this;
        }

        public Builder messageWithManuallyTranslatedDescription(String string, String string2, String string3) {
            this.message = string;
            this.description = string2;
            this.descriptionEn = string3;
            return this;
        }

        public Builder message(String string, String string2, Object ... objectArray) {
            this.message = string;
            this.description = I18n.tr(string2, objectArray);
            this.descriptionEn = new MessageFormat(string2, Locale.ENGLISH).format(objectArray);
            return this;
        }

        public Builder primitives(OsmPrimitive ... osmPrimitiveArray) {
            return this.primitives(Arrays.asList(osmPrimitiveArray));
        }

        public Builder primitives(Collection<? extends OsmPrimitive> collection) {
            CheckParameterUtil.ensureThat(this.primitives == null, "primitives already set");
            CheckParameterUtil.ensureParameterNotNull(collection, "primitives");
            this.primitives = collection;
            if (this.highlighted == null) {
                this.highlighted = collection;
            }
            return this;
        }

        public Builder highlight(OsmPrimitive ... osmPrimitiveArray) {
            return this.highlight(Arrays.asList(osmPrimitiveArray));
        }

        public Builder highlight(Collection<? extends OsmPrimitive> collection) {
            CheckParameterUtil.ensureParameterNotNull(collection, "highlighted");
            this.highlighted = collection;
            return this;
        }

        public Builder highlightWaySegments(Collection<WaySegment> collection) {
            CheckParameterUtil.ensureParameterNotNull(collection, "highlighted");
            this.highlighted = collection;
            return this;
        }

        public Builder highlightNodePairs(Collection<List<Node>> collection) {
            CheckParameterUtil.ensureParameterNotNull(collection, "highlighted");
            this.highlighted = collection;
            return this;
        }

        public Builder fix(Supplier<Command> supplier) {
            CheckParameterUtil.ensureThat(this.fixingCommand == null, "fixingCommand already set");
            this.fixingCommand = supplier;
            return this;
        }

        public TestError build() {
            CheckParameterUtil.ensureParameterNotNull(this.message, "message not set");
            CheckParameterUtil.ensureParameterNotNull(this.primitives, "primitives not set");
            CheckParameterUtil.ensureThat(!this.primitives.isEmpty(), "primitives is empty");
            if (this.highlighted == null) {
                this.highlighted = Collections.emptySet();
            }
            return new TestError(this);
        }
    }
}

