/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.routines;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.data.validation.routines.DomainValidator;
import org.openstreetmap.josm.data.validation.routines.InetAddressValidator;
import org.openstreetmap.josm.tools.I18n;

public class EmailValidator
extends AbstractValidator {
    private static final String SPECIAL_CHARS = "\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]";
    private static final String VALID_CHARS = "(\\\\.)|[^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]";
    private static final String QUOTED_USER = "(\"(\\\\\"|[^\"])*\")";
    private static final String WORD = "(((\\\\.)|[^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"(\\\\\"|[^\"])*\"))";
    private static final String EMAIL_REGEX = "^\\s*?(.+)@(.+?)\\s*$";
    private static final String IP_DOMAIN_REGEX = "^\\[(.*)\\]$";
    private static final String USER_REGEX = "^\\s*(((\\\\.)|[^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"(\\\\\"|[^\"])*\"))(\\.(((\\\\.)|[^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"(\\\\\"|[^\"])*\")))*$";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^\\s*?(.+)@(.+?)\\s*$");
    private static final Pattern IP_DOMAIN_PATTERN = Pattern.compile("^\\[(.*)\\]$");
    private static final Pattern USER_PATTERN = Pattern.compile("^\\s*(((\\\\.)|[^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"(\\\\\"|[^\"])*\"))(\\.(((\\\\.)|[^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"(\\\\\"|[^\"])*\")))*$");
    private static final int MAX_USERNAME_LEN = 64;
    private final boolean allowLocal;
    private final boolean allowTld;
    private static final EmailValidator EMAIL_VALIDATOR = new EmailValidator(false, false);
    private static final EmailValidator EMAIL_VALIDATOR_WITH_TLD = new EmailValidator(false, true);
    private static final EmailValidator EMAIL_VALIDATOR_WITH_LOCAL = new EmailValidator(true, false);

    public static EmailValidator getInstance() {
        return EMAIL_VALIDATOR;
    }

    public static EmailValidator getInstance(boolean bl, boolean bl2) {
        if (bl) {
            return EMAIL_VALIDATOR_WITH_LOCAL;
        }
        if (bl2) {
            return EMAIL_VALIDATOR_WITH_TLD;
        }
        return EMAIL_VALIDATOR;
    }

    public static EmailValidator getInstance(boolean bl) {
        return EmailValidator.getInstance(bl, false);
    }

    protected EmailValidator(boolean bl, boolean bl2) {
        this.allowLocal = bl;
        this.allowTld = bl2;
    }

    @Override
    public boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        if (string.endsWith(".")) {
            this.setErrorMessage(I18n.tr("E-mail address is invalid", new Object[0]));
            return false;
        }
        Matcher matcher = EMAIL_PATTERN.matcher(string);
        if (!matcher.matches()) {
            this.setErrorMessage(I18n.tr("E-mail address is invalid", new Object[0]));
            return false;
        }
        String string2 = matcher.group(1);
        if (!this.isValidUser(string2)) {
            this.setErrorMessage(I18n.tr("E-mail address contains an invalid username: {0}", string2));
            return false;
        }
        String string3 = matcher.group(2);
        if (!this.isValidDomain(string3)) {
            this.setErrorMessage(I18n.tr("E-mail address contains an invalid domain: {0}", string3));
            return false;
        }
        return true;
    }

    @Override
    public String getValidatorName() {
        return I18n.tr("Email validator", new Object[0]);
    }

    protected boolean isValidDomain(String string) {
        Matcher matcher = IP_DOMAIN_PATTERN.matcher(string);
        if (matcher.matches()) {
            InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();
            return inetAddressValidator.isValid(matcher.group(1));
        }
        DomainValidator domainValidator = DomainValidator.getInstance(this.allowLocal);
        if (this.allowTld) {
            return domainValidator.isValid(string) || !string.startsWith(".") && domainValidator.isValidTld(string);
        }
        return domainValidator.isValid(string);
    }

    protected boolean isValidUser(String string) {
        if (string == null || string.length() > 64) {
            return false;
        }
        return USER_PATTERN.matcher(string).matches();
    }
}

