/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;

public class SelectionTable
extends JTable {
    private final SelectionTableModel model;
    private final MemberTableModel memberTableModel;

    public SelectionTable(SelectionTableModel selectionTableModel, MemberTableModel memberTableModel) {
        super(selectionTableModel, new SelectionTableColumnModel(memberTableModel));
        this.model = selectionTableModel;
        this.memberTableModel = memberTableModel;
        this.build();
    }

    protected void build() {
        this.setSelectionMode(0);
        this.addMouseListener(new DoubleClickAdapter());
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.getClickCount() <= 1) {
                return;
            }
            int n = SelectionTable.this.rowAtPoint(mouseEvent.getPoint());
            SelectionTable.this.memberTableModel.selectMembersReferringTo(Collections.singleton(SelectionTable.this.model.getPrimitive(n)));
        }
    }
}

