/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class LayerManager {
    private volatile List<Layer> layers = Collections.emptyList();
    private final List<LayerChangeListener> layerChangeListeners = new CopyOnWriteArrayList<LayerChangeListener>();

    public void addLayer(Layer layer) {
        this.addLayer(layer, true);
    }

    public void addLayer(Layer layer, boolean bl) {
        GuiHelper.runInEDTAndWaitWithException(() -> this.realAddLayer(layer, bl));
    }

    protected synchronized void realAddLayer(Layer layer, boolean bl) {
        if (this.containsLayer(layer)) {
            throw new IllegalArgumentException("Cannot add a layer twice: " + layer);
        }
        LayerPositionStrategy layerPositionStrategy = layer.getDefaultLayerPosition();
        int n = layerPositionStrategy.getPosition(this);
        this.checkPosition(n);
        this.insertLayerAt(layer, n);
        this.fireLayerAdded(layer, bl);
        if (Main.map != null) {
            layer.hookUpMapView();
        }
    }

    public void removeLayer(Layer layer) {
        GuiHelper.runInEDTAndWaitWithException(() -> this.realRemoveLayer(layer));
    }

    protected synchronized void realRemoveLayer(Layer layer) {
        GuiHelper.assertCallFromEdt();
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        set.add(layer);
        while (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            Layer layer2 = (Layer)iterator.next();
            iterator.remove();
            this.checkContainsLayer(layer2);
            Collection<Layer> collection = this.realRemoveSingleLayer(layer2);
            set.addAll(collection);
        }
    }

    protected Collection<Layer> realRemoveSingleLayer(Layer layer) {
        this.updateLayers(list -> list.remove(layer));
        return this.fireLayerRemoving(layer);
    }

    public void moveLayer(Layer layer, int n) {
        GuiHelper.runInEDTAndWaitWithException(() -> this.realMoveLayer(layer, n));
    }

    protected synchronized void realMoveLayer(Layer layer, int n) {
        this.checkContainsLayer(layer);
        this.checkPosition(n);
        int n2 = this.getLayers().indexOf(layer);
        if (n == n2) {
            return;
        }
        this.updateLayers(list -> {
            list.remove(n2);
            LayerManager.insertLayerAt(list, layer, n);
        });
        this.fireLayerOrderChanged();
    }

    private void insertLayerAt(Layer layer, int n) {
        this.updateLayers(list -> LayerManager.insertLayerAt(list, layer, n));
    }

    private static void insertLayerAt(List<Layer> list, Layer layer, int n) {
        if (n == list.size()) {
            list.add(layer);
        } else {
            list.add(n, layer);
        }
    }

    private void checkPosition(int n) {
        if (n < 0 || n > this.getLayers().size()) {
            throw new IndexOutOfBoundsException("Position " + n + " out of range.");
        }
    }

    private void updateLayers(Consumer<List<Layer>> consumer) {
        GuiHelper.assertCallFromEdt();
        ArrayList<Layer> arrayList = new ArrayList<Layer>(this.getLayers());
        consumer.accept(arrayList);
        this.layers = Collections.unmodifiableList(arrayList);
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public <T extends Layer> List<T> getLayersOfType(Class<T> clazz) {
        return new ArrayList(Utils.filteredCollection(this.getLayers(), clazz));
    }

    public boolean containsLayer(Layer layer) {
        return this.getLayers().contains(layer);
    }

    protected void checkContainsLayer(Layer layer) {
        if (!this.containsLayer(layer)) {
            throw new IllegalArgumentException(layer + " is not managed by us.");
        }
    }

    public synchronized void addLayerChangeListener(LayerChangeListener layerChangeListener) {
        if (this.layerChangeListeners.contains(layerChangeListener)) {
            throw new IllegalArgumentException("Listener already registered.");
        }
        this.layerChangeListeners.add(layerChangeListener);
    }

    public synchronized void addAndFireLayerChangeListener(LayerChangeListener layerChangeListener) {
        this.addLayerChangeListener(layerChangeListener);
        for (Layer layer : this.getLayers()) {
            layerChangeListener.layerAdded(new LayerAddEvent(this, layer, true));
        }
    }

    public synchronized void removeLayerChangeListener(LayerChangeListener layerChangeListener) {
        if (!this.layerChangeListeners.remove(layerChangeListener)) {
            throw new IllegalArgumentException("Listener was not registered before: " + layerChangeListener);
        }
    }

    public synchronized void removeAndFireLayerChangeListener(LayerChangeListener layerChangeListener) {
        this.removeLayerChangeListener(layerChangeListener);
        for (Layer layer : this.getLayers()) {
            layerChangeListener.layerRemoving(new LayerRemoveEvent(this, layer));
        }
    }

    private void fireLayerAdded(Layer layer, boolean bl) {
        GuiHelper.assertCallFromEdt();
        LayerAddEvent layerAddEvent = new LayerAddEvent(this, layer, bl);
        for (LayerChangeListener layerChangeListener : this.layerChangeListeners) {
            try {
                layerChangeListener.layerAdded(layerAddEvent);
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
                throw BugReport.intercept(runtimeException).put("listener", layerChangeListener).put("event", layerAddEvent);
            }
        }
    }

    private Collection<Layer> fireLayerRemoving(Layer layer) {
        GuiHelper.assertCallFromEdt();
        LayerRemoveEvent layerRemoveEvent = new LayerRemoveEvent(this, layer);
        for (LayerChangeListener layerChangeListener : this.layerChangeListeners) {
            try {
                layerChangeListener.layerRemoving(layerRemoveEvent);
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
                throw BugReport.intercept(runtimeException).put("listener", layerChangeListener).put("event", layerRemoveEvent).put("layer", layer);
            }
        }
        return layerRemoveEvent.scheduleForRemoval;
    }

    private void fireLayerOrderChanged() {
        GuiHelper.assertCallFromEdt();
        LayerOrderChangeEvent layerOrderChangeEvent = new LayerOrderChangeEvent(this);
        for (LayerChangeListener layerChangeListener : this.layerChangeListeners) {
            try {
                layerChangeListener.layerOrderChanged(layerOrderChangeEvent);
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
                throw BugReport.intercept(runtimeException).put("listener", layerChangeListener).put("event", layerOrderChangeEvent);
            }
        }
    }

    public void resetState() {
        GuiHelper.runInEDTAndWaitWithException(this::realResetState);
    }

    protected synchronized void realResetState() {
        while (!this.getLayers().isEmpty()) {
            this.removeLayer(this.getLayers().get(0));
        }
        this.layerChangeListeners.clear();
    }

    public static class LayerOrderChangeEvent
    extends LayerManagerEvent {
        LayerOrderChangeEvent(LayerManager layerManager) {
            super(layerManager);
        }

        public String toString() {
            return "LayerOrderChangeEvent []";
        }
    }

    public static class LayerRemoveEvent
    extends LayerManagerEvent {
        private final Layer removedLayer;
        private final boolean lastLayer;
        private final Collection<Layer> scheduleForRemoval = new ArrayList<Layer>();

        LayerRemoveEvent(LayerManager layerManager, Layer layer) {
            super(layerManager);
            this.removedLayer = layer;
            this.lastLayer = layerManager.getLayers().size() == 1;
        }

        public Layer getRemovedLayer() {
            return this.removedLayer;
        }

        public boolean isLastLayer() {
            return this.lastLayer;
        }

        public void scheduleRemoval(Collection<? extends Layer> collection) {
            for (Layer layer : collection) {
                this.getSource().checkContainsLayer(layer);
            }
            this.scheduleForRemoval.addAll(collection);
        }

        public String toString() {
            return "LayerRemoveEvent [removedLayer=" + this.removedLayer + ", lastLayer=" + this.lastLayer + ']';
        }
    }

    public static class LayerAddEvent
    extends LayerManagerEvent {
        private final Layer addedLayer;
        private final boolean requiresZoom;

        LayerAddEvent(LayerManager layerManager, Layer layer, boolean bl) {
            super(layerManager);
            this.addedLayer = layer;
            this.requiresZoom = bl;
        }

        public Layer getAddedLayer() {
            return this.addedLayer;
        }

        public final boolean isZoomRequired() {
            return this.requiresZoom;
        }

        public String toString() {
            return "LayerAddEvent [addedLayer=" + this.addedLayer + ']';
        }
    }

    protected static class LayerManagerEvent {
        private final LayerManager source;

        LayerManagerEvent(LayerManager layerManager) {
            this.source = layerManager;
        }

        public LayerManager getSource() {
            return this.source;
        }
    }

    public static interface LayerChangeListener {
        public void layerAdded(LayerAddEvent var1);

        public void layerRemoving(LayerRemoveEvent var1);

        public void layerOrderChanged(LayerOrderChangeEvent var1);
    }
}

