/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.CompoundException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public final class ImageEntry
implements Comparable<ImageEntry>,
Cloneable {
    private File file;
    private Integer exifOrientation;
    private LatLon exifCoor;
    private Double exifImgDir;
    private Date exifTime;
    private boolean isNewGpsData;
    private Date exifGpsTime;
    private Image thumbnail;
    private CachedLatLon pos;
    private Double speed;
    private Double elevation;
    private Date gpsTime;
    ImageEntry tmp;

    public ImageEntry() {
    }

    public ImageEntry(File file) {
        this.setFile(file);
    }

    public CachedLatLon getPos() {
        if (this.tmp != null) {
            return this.tmp.pos;
        }
        return this.pos;
    }

    public Double getSpeed() {
        if (this.tmp != null) {
            return this.tmp.speed;
        }
        return this.speed;
    }

    public Double getElevation() {
        if (this.tmp != null) {
            return this.tmp.elevation;
        }
        return this.elevation;
    }

    public Date getGpsTime() {
        if (this.tmp != null) {
            return ImageEntry.getDefensiveDate(this.tmp.gpsTime);
        }
        return ImageEntry.getDefensiveDate(this.gpsTime);
    }

    public boolean hasGpsTime() {
        return this.tmp != null && this.tmp.gpsTime != null || this.gpsTime != null;
    }

    public File getFile() {
        return this.file;
    }

    public Integer getExifOrientation() {
        return this.exifOrientation;
    }

    public Date getExifTime() {
        return ImageEntry.getDefensiveDate(this.exifTime);
    }

    public boolean hasExifTime() {
        return this.exifTime != null;
    }

    public Date getExifGpsTime() {
        return ImageEntry.getDefensiveDate(this.exifGpsTime);
    }

    public boolean hasExifGpsTime() {
        return this.exifGpsTime != null;
    }

    private static Date getDefensiveDate(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public LatLon getExifCoor() {
        return this.exifCoor;
    }

    public Double getExifImgDir() {
        if (this.tmp != null) {
            return this.tmp.exifImgDir;
        }
        return this.exifImgDir;
    }

    public boolean hasThumbnail() {
        return this.thumbnail != null;
    }

    public Image getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Image image) {
        this.thumbnail = image;
    }

    public void loadThumbnail() {
        if (this.thumbnail == null) {
            new ThumbsLoader(Collections.singleton(this)).run();
        }
    }

    public void setPos(CachedLatLon cachedLatLon) {
        this.pos = cachedLatLon;
    }

    public void setPos(LatLon latLon) {
        this.setPos(latLon != null ? new CachedLatLon(latLon) : null);
    }

    public void setSpeed(Double d) {
        this.speed = d;
    }

    public void setElevation(Double d) {
        this.elevation = d;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setExifOrientation(Integer n) {
        this.exifOrientation = n;
    }

    public void setExifTime(Date date) {
        this.exifTime = ImageEntry.getDefensiveDate(date);
    }

    public void setExifGpsTime(Date date) {
        this.exifGpsTime = ImageEntry.getDefensiveDate(date);
    }

    public void setGpsTime(Date date) {
        this.gpsTime = ImageEntry.getDefensiveDate(date);
    }

    public void setExifCoor(LatLon latLon) {
        this.exifCoor = latLon;
    }

    public void setExifImgDir(Double d) {
        this.exifImgDir = d;
    }

    public ImageEntry clone() {
        try {
            return (ImageEntry)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    @Override
    public int compareTo(ImageEntry imageEntry) {
        if (this.exifTime != null && imageEntry.exifTime != null) {
            return this.exifTime.compareTo(imageEntry.exifTime);
        }
        if (this.exifTime == null && imageEntry.exifTime == null) {
            return 0;
        }
        if (this.exifTime == null) {
            return -1;
        }
        return 1;
    }

    public void createTmp() {
        this.tmp = this.clone();
        this.tmp.tmp = null;
    }

    public ImageEntry getTmp() {
        if (this.tmp == null) {
            this.createTmp();
        }
        return this.tmp;
    }

    public void applyTmp() {
        if (this.tmp != null) {
            this.pos = this.tmp.pos;
            this.speed = this.tmp.speed;
            this.elevation = this.tmp.elevation;
            this.gpsTime = this.tmp.gpsTime;
            this.exifImgDir = this.tmp.exifImgDir;
            this.tmp = null;
        }
    }

    public void discardTmp() {
        this.tmp = null;
    }

    public boolean isTagged() {
        return this.pos != null;
    }

    public String toString() {
        return this.file.getName() + ": pos = " + this.pos + " | exifCoor = " + this.exifCoor + " | " + (this.tmp == null ? " tmp==null" : " [tmp] pos = " + this.tmp.pos);
    }

    public void flagNewGpsData() {
        this.isNewGpsData = true;
    }

    public void unflagNewGpsData() {
        this.isNewGpsData = false;
    }

    public boolean hasNewGpsData() {
        return this.isNewGpsData;
    }

    public void extractExif() {
        Serializable serializable;
        Double d;
        Metadata metadata;
        if (this.file == null) {
            return;
        }
        try {
            metadata = JpegMetadataReader.readMetadata(this.file);
        }
        catch (CompoundException | IOException exception) {
            Main.error(exception);
            this.setExifTime(null);
            this.setExifCoor(null);
            this.setPos(null);
            return;
        }
        try {
            this.setExifTime(ExifReader.readTime(metadata));
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException runtimeException) {
            Main.warn(runtimeException);
            this.setExifTime(null);
        }
        ExifIFD0Directory exifIFD0Directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        GpsDirectory gpsDirectory = metadata.getFirstDirectoryOfType(GpsDirectory.class);
        try {
            if (exifIFD0Directory != null) {
                int n = exifIFD0Directory.getInt(274);
                this.setExifOrientation(n);
            }
        }
        catch (MetadataException metadataException) {
            Main.debug(metadataException);
        }
        if (gpsDirectory == null) {
            this.setExifCoor(null);
            this.setPos(null);
            return;
        }
        Double d2 = ExifReader.readSpeed(gpsDirectory);
        if (d2 != null) {
            this.setSpeed(d2);
        }
        if ((d = ExifReader.readElevation(gpsDirectory)) != null) {
            this.setElevation(d);
        }
        try {
            serializable = ExifReader.readLatLon(gpsDirectory);
            this.setExifCoor((LatLon)serializable);
            this.setPos(this.getExifCoor());
        }
        catch (MetadataException | IndexOutOfBoundsException exception) {
            Main.error("Error reading EXIF from file: " + exception);
            this.setExifCoor(null);
            this.setPos(null);
        }
        try {
            serializable = ExifReader.readDirection(gpsDirectory);
            if (serializable != null) {
                this.setExifImgDir((Double)serializable);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Main.debug(indexOutOfBoundsException);
        }
        serializable = gpsDirectory.getGpsDate();
        if (serializable != null) {
            this.setExifGpsTime((Date)serializable);
        }
    }
}

