/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Objects;

public class Range {
    private final double lower;
    private final double upper;
    public static final Range ZERO_TO_INFINITY = new Range(0.0, Double.POSITIVE_INFINITY);

    public Range(double d, double d2) {
        if (d < 0.0 || d >= d2) {
            throw new IllegalArgumentException("Invalid range: " + d + '-' + d2);
        }
        this.lower = d;
        this.upper = d2;
    }

    public boolean contains(double d) {
        return this.lower < d && d <= this.upper;
    }

    public static Range cut(Range range, Range range2) {
        if (range2.lower >= range.upper || range2.upper <= range.lower) {
            throw new IllegalArgumentException("Ranges do not overlap: " + range + " - " + range2);
        }
        return new Range(Math.max(range.lower, range2.lower), Math.min(range.upper, range2.upper));
    }

    public Range reduceAround(double d, Range range) {
        if (!this.contains(d)) {
            throw new IllegalArgumentException(d + " is not inside " + this);
        }
        if (range.contains(d)) {
            throw new IllegalArgumentException(d + " is inside " + range);
        }
        if (d < range.lower && range.lower < this.upper) {
            return new Range(this.lower, range.lower);
        }
        if (this.lower < range.upper && range.upper < d) {
            return new Range(range.upper, this.upper);
        }
        return this;
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public String toString() {
        return String.format("|s%s-%s", this.lower, this.upper);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Range range = (Range)object;
        return Double.compare(range.lower, this.lower) == 0 && Double.compare(range.upper, this.upper) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.lower, this.upper);
    }
}

