/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;

@FunctionalInterface
public interface Subpart {
    public static final Subpart DEFAULT_SUBPART = new StringSubpart("default");

    public String getId(Environment var1);

    public static class ExpressionSubpart
    implements Subpart {
        private final Expression id;

        public ExpressionSubpart(Expression expression) {
            this.id = expression;
        }

        @Override
        public String getId(Environment environment) {
            return Cascade.convertTo(this.id.evaluate(environment), String.class);
        }

        public String toString() {
            return String.valueOf(this.id);
        }
    }

    public static class StringSubpart
    implements Subpart {
        private final String id;

        public StringSubpart(String string) {
            this.id = string;
        }

        @Override
        public String getId(Environment environment) {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

