/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPriority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class AutoCompletionManager
implements DataSetListener {
    protected boolean dirty;
    protected DataSet ds;
    protected MultiMap<String, String> tagCache;
    static final MultiMap<String, String> PRESET_TAG_CACHE = new MultiMap();
    static final Set<UserInputTag> USER_INPUT_TAG_CACHE = new LinkedHashSet<UserInputTag>();
    protected Set<String> roleCache;
    static final Set<String> PRESET_ROLE_CACHE = new HashSet<String>();

    public AutoCompletionManager(DataSet dataSet) {
        this.ds = dataSet;
        this.dirty = true;
    }

    protected MultiMap<String, String> getTagCache() {
        if (this.dirty) {
            this.rebuild();
            this.dirty = false;
        }
        return this.tagCache;
    }

    protected Set<String> getRoleCache() {
        if (this.dirty) {
            this.rebuild();
            this.dirty = false;
        }
        return this.roleCache;
    }

    protected void rebuild() {
        this.tagCache = new MultiMap();
        this.roleCache = new HashSet<String>();
        this.cachePrimitives(this.ds.allNonDeletedCompletePrimitives());
    }

    protected void cachePrimitives(Collection<? extends OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            this.cachePrimitiveTags(osmPrimitive);
            if (!(osmPrimitive instanceof Relation)) continue;
            this.cacheRelationMemberRoles((Relation)osmPrimitive);
        }
    }

    protected void cachePrimitiveTags(OsmPrimitive osmPrimitive) {
        for (String string : osmPrimitive.keySet()) {
            String string2 = osmPrimitive.get(string);
            this.tagCache.put(string, string2);
        }
    }

    protected void cacheRelationMemberRoles(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.hasRole()) continue;
            this.roleCache.add(relationMember.getRole());
        }
    }

    public static void rememberUserInput(String string, String string2, boolean bl) {
        UserInputTag userInputTag = new UserInputTag(string, string2, bl);
        USER_INPUT_TAG_CACHE.remove(userInputTag);
        USER_INPUT_TAG_CACHE.add(userInputTag);
    }

    protected List<String> getDataKeys() {
        return new ArrayList<String>(this.getTagCache().keySet());
    }

    protected Collection<String> getUserInputKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UserInputTag userInputTag : USER_INPUT_TAG_CACHE) {
            if (userInputTag.defaultKey) continue;
            arrayList.add(userInputTag.key);
        }
        Collections.reverse(arrayList);
        return new LinkedHashSet<String>(arrayList);
    }

    protected List<String> getDataValues(String string) {
        return new ArrayList<String>(this.getTagCache().getValues(string));
    }

    protected static Collection<String> getUserInputValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UserInputTag userInputTag : USER_INPUT_TAG_CACHE) {
            if (!string.equals(userInputTag.key)) continue;
            arrayList.add(userInputTag.value);
        }
        Collections.reverse(arrayList);
        return new LinkedHashSet<String>(arrayList);
    }

    public List<String> getMemberRoles() {
        return new ArrayList<String>(this.getRoleCache());
    }

    public void populateWithMemberRoles(AutoCompletionList autoCompletionList) {
        autoCompletionList.add(TaggingPresets.getPresetRoles(), AutoCompletionItemPriority.IS_IN_STANDARD);
        autoCompletionList.add(this.getRoleCache(), AutoCompletionItemPriority.IS_IN_DATASET);
    }

    public void populateWithMemberRoles(AutoCompletionList autoCompletionList, Relation relation) {
        Collection<TaggingPreset> collection;
        CheckParameterUtil.ensureParameterNotNull(autoCompletionList, "list");
        Collection<TaggingPreset> collection2 = collection = relation != null ? TaggingPresets.getMatchingPresets(null, relation.getKeys(), false) : null;
        if (relation != null && collection != null && !collection.isEmpty()) {
            for (TaggingPreset taggingPreset : collection) {
                if (taggingPreset.roles == null) continue;
                autoCompletionList.add(Utils.transform(taggingPreset.roles.roles, role -> role.key), AutoCompletionItemPriority.IS_IN_STANDARD);
            }
            autoCompletionList.add(relation.getMemberRoles(), AutoCompletionItemPriority.IS_IN_DATASET);
        } else {
            this.populateWithMemberRoles(autoCompletionList);
        }
    }

    public void populateWithKeys(AutoCompletionList autoCompletionList) {
        autoCompletionList.add(TaggingPresets.getPresetKeys(), AutoCompletionItemPriority.IS_IN_STANDARD);
        autoCompletionList.add(new AutoCompletionListItem("source", AutoCompletionItemPriority.IS_IN_STANDARD));
        autoCompletionList.add(this.getDataKeys(), AutoCompletionItemPriority.IS_IN_DATASET);
        autoCompletionList.addUserInput(this.getUserInputKeys());
    }

    public void populateWithTagValues(AutoCompletionList autoCompletionList, String string) {
        this.populateWithTagValues(autoCompletionList, Arrays.asList(string));
    }

    public void populateWithTagValues(AutoCompletionList autoCompletionList, List<String> list) {
        for (String string : list) {
            autoCompletionList.add(TaggingPresets.getPresetValues(string), AutoCompletionItemPriority.IS_IN_STANDARD);
            autoCompletionList.add(this.getDataValues(string), AutoCompletionItemPriority.IS_IN_DATASET);
            autoCompletionList.addUserInput(AutoCompletionManager.getUserInputValues(string));
        }
    }

    public List<AutoCompletionListItem> getKeys() {
        AutoCompletionList autoCompletionList = new AutoCompletionList();
        this.populateWithKeys(autoCompletionList);
        return autoCompletionList.getList();
    }

    public List<AutoCompletionListItem> getValues(String string) {
        return this.getValues(Arrays.asList(string));
    }

    public List<AutoCompletionListItem> getValues(List<String> list) {
        AutoCompletionList autoCompletionList = new AutoCompletionList();
        this.populateWithTagValues(autoCompletionList, list);
        return autoCompletionList.getList();
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        if (this.dirty) {
            return;
        }
        this.cachePrimitives(primitivesAddedEvent.getPrimitives());
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        this.dirty = true;
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        if (this.dirty) {
            return;
        }
        TagMap tagMap = tagsChangedEvent.getPrimitive().getKeys();
        Map<String, String> map = tagsChangedEvent.getOriginalKeys();
        if (!tagMap.keySet().containsAll(map.keySet())) {
            this.dirty = true;
        } else {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getValue().equals(tagMap.get(entry.getKey()))) continue;
                this.dirty = true;
                return;
            }
            this.cachePrimitives(Collections.singleton(tagsChangedEvent.getPrimitive()));
        }
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
        this.dirty = true;
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
        this.dirty = true;
    }

    public static class UserInputTag {
        private final String key;
        private final String value;
        private final boolean defaultKey;

        public UserInputTag(String string, String string2, boolean bl) {
            this.key = string;
            this.value = string2;
            this.defaultKey = bl;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value, this.defaultKey);
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            UserInputTag userInputTag = (UserInputTag)object;
            return this.defaultKey == userInputTag.defaultKey && Objects.equals(this.key, userInputTag.key) && Objects.equals(this.value, userInputTag.value);
        }
    }
}

