/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.widgets.ComboBoxHistory;

public class HistoryComboBox
extends AutoCompletingComboBox {
    private final ComboBoxHistory model;
    public static final int DEFAULT_SEARCH_HISTORY_SIZE = 15;

    public HistoryComboBox() {
        int n = Main.pref.getInteger("search.history-size", 15);
        this.model = new ComboBoxHistory(n);
        this.setModel(this.model);
        this.setEditable(true);
    }

    public String getText() {
        return this.getEditorComponent().getText();
    }

    public void setText(String string) {
        this.setAutocompleteEnabled(false);
        this.getEditorComponent().setText(string);
        this.setAutocompleteEnabled(true);
    }

    public void addCurrentItemToHistory() {
        this.model.addElement((String)this.getEditor().getItem());
    }

    public void setHistory(List<String> list) {
        this.model.setItemsAsString(list);
    }

    public List<String> getHistory() {
        return this.model.asStringList();
    }
}

