/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Utils;

public final class WinRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final int REG_SUCCESS = 0;
    private static final int KEY_READ = 131097;
    private static final Preferences userRoot = Preferences.userRoot();
    private static final Preferences systemRoot = Preferences.systemRoot();
    private static final Class<? extends Preferences> userClass = userRoot.getClass();
    private static final Method regOpenKey;
    private static final Method regCloseKey;
    private static final Method regQueryValueEx;
    private static final Method regEnumValue;
    private static final Method regQueryInfoKey;
    private static final Method regEnumKeyEx;

    private WinRegistry() {
    }

    public static String readString(int n, String string, String string2) throws IllegalAccessException, InvocationTargetException {
        if (n == -2147483646) {
            return WinRegistry.readString(systemRoot, n, string, string2);
        }
        if (n == -2147483647) {
            return WinRegistry.readString(userRoot, n, string, string2);
        }
        throw new IllegalArgumentException("hkey=" + n);
    }

    public static Map<String, String> readStringValues(int n, String string) throws IllegalAccessException, InvocationTargetException {
        if (n == -2147483646) {
            return WinRegistry.readStringValues(systemRoot, n, string);
        }
        if (n == -2147483647) {
            return WinRegistry.readStringValues(userRoot, n, string);
        }
        throw new IllegalArgumentException("hkey=" + n);
    }

    public static List<String> readStringSubKeys(int n, String string) throws IllegalAccessException, InvocationTargetException {
        if (n == -2147483646) {
            return WinRegistry.readStringSubKeys(systemRoot, n, string);
        }
        if (n == -2147483647) {
            return WinRegistry.readStringSubKeys(userRoot, n, string);
        }
        throw new IllegalArgumentException("hkey=" + n);
    }

    private static String readString(Preferences preferences, int n, String string, String string2) throws IllegalAccessException, InvocationTargetException {
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, n, WinRegistry.toCstr(string), 131097);
        if (nArray[1] != 0) {
            return null;
        }
        byte[] byArray = (byte[])regQueryValueEx.invoke((Object)preferences, nArray[0], WinRegistry.toCstr(string2));
        regCloseKey.invoke((Object)preferences, nArray[0]);
        return byArray != null ? new String(byArray, StandardCharsets.UTF_8).trim() : null;
    }

    private static Map<String, String> readStringValues(Preferences preferences, int n, String string) throws IllegalAccessException, InvocationTargetException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, n, WinRegistry.toCstr(string), 131097);
        if (nArray[1] != 0) {
            return null;
        }
        int[] nArray2 = (int[])regQueryInfoKey.invoke((Object)preferences, nArray[0]);
        int n2 = nArray2[0];
        int n3 = nArray2[3];
        for (int i = 0; i < n2; ++i) {
            byte[] byArray = (byte[])regEnumValue.invoke((Object)preferences, nArray[0], i, n3 + 1);
            String string2 = WinRegistry.readString(n, string, new String(byArray, StandardCharsets.UTF_8));
            hashMap.put(new String(byArray, StandardCharsets.UTF_8).trim(), string2);
        }
        regCloseKey.invoke((Object)preferences, nArray[0]);
        return hashMap;
    }

    private static List<String> readStringSubKeys(Preferences preferences, int n, String string) throws IllegalAccessException, InvocationTargetException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = (int[])regOpenKey.invoke((Object)preferences, n, WinRegistry.toCstr(string), 131097);
        if (nArray[1] != 0) {
            return Collections.emptyList();
        }
        int[] nArray2 = (int[])regQueryInfoKey.invoke((Object)preferences, nArray[0]);
        int n2 = nArray2[0];
        int n3 = nArray2[3];
        for (int i = 0; i < n2; ++i) {
            byte[] byArray = (byte[])regEnumKeyEx.invoke((Object)preferences, nArray[0], i, n3 + 1);
            arrayList.add(new String(byArray, StandardCharsets.UTF_8).trim());
        }
        regCloseKey.invoke((Object)preferences, nArray[0]);
        return arrayList;
    }

    private static byte[] toCstr(String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length + 1);
        byArray2[byArray.length] = 0;
        return byArray2;
    }

    static {
        try {
            regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regEnumValue = userClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            regQueryInfoKey = userClass.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
            regEnumKeyEx = userClass.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Utils.setObjectsAccessible(regOpenKey, regCloseKey, regQueryValueEx, regEnumValue, regQueryInfoKey, regEnumKeyEx);
        }
        catch (ReflectiveOperationException | SecurityException exception) {
            throw new JosmRuntimeException(exception);
        }
    }
}

