/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.MemInStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rdr.ZlibInStream;
import com.tigervnc.rfb.ConnParams;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Rect;
import java.nio.ByteBuffer;

public class ZRLEDecoder
extends Decoder {
    private ZlibInStream zis = new ZlibInStream();

    private static int readOpaque24A(InStream inStream) {
        inStream.check(3);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put(0, (byte)inStream.readU8());
        byteBuffer.put(1, (byte)inStream.readU8());
        byteBuffer.put(2, (byte)inStream.readU8());
        return ((ByteBuffer)byteBuffer.rewind()).getInt();
    }

    private static int readOpaque24B(InStream inStream) {
        inStream.check(3);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put(2, (byte)inStream.readU8());
        byteBuffer.put(1, (byte)inStream.readU8());
        byteBuffer.put(0, (byte)inStream.readU8());
        return ((ByteBuffer)byteBuffer.rewind()).getInt();
    }

    public ZRLEDecoder() {
        super(Decoder.DecoderFlags.DecoderOrdered);
    }

    @Override
    public void readRect(Rect rect, InStream inStream, ConnParams connParams, OutStream outStream) {
        int n = inStream.readU32();
        outStream.writeU32(n);
        outStream.copyBytes(inStream, n);
    }

    @Override
    public void decodeRect(Rect rect, Object object, int n, ConnParams connParams, ModifiablePixelBuffer modifiablePixelBuffer) {
        MemInStream memInStream = new MemInStream((byte[])object, 0, n);
        PixelFormat pixelFormat = connParams.pf();
        ByteBuffer byteBuffer = ByteBuffer.allocate(16384);
        switch (pixelFormat.bpp) {
            case 8: {
                this.zrleDecode8(rect, memInStream, this.zis, byteBuffer, pixelFormat, modifiablePixelBuffer);
                break;
            }
            case 16: {
                this.zrleDecode16(rect, memInStream, this.zis, byteBuffer, pixelFormat, modifiablePixelBuffer);
                break;
            }
            case 32: {
                boolean bl;
                int n2 = pixelFormat.pixelFromRGB(-1, -1, -1, pixelFormat.getColorModel());
                boolean bl2 = n2 < 0x1000000;
                boolean bl3 = bl = (n2 & 0xFF) == 0;
                if (bl2 && pixelFormat.isLittleEndian() || bl && pixelFormat.isBigEndian()) {
                    this.zrleDecode24A(rect, memInStream, this.zis, byteBuffer, pixelFormat, modifiablePixelBuffer);
                    break;
                }
                if (bl2 && pixelFormat.isBigEndian() || bl && pixelFormat.isLittleEndian()) {
                    this.zrleDecode24B(rect, memInStream, this.zis, byteBuffer, pixelFormat, modifiablePixelBuffer);
                    break;
                }
                this.zrleDecode32(rect, memInStream, this.zis, byteBuffer, pixelFormat, modifiablePixelBuffer);
            }
        }
    }

    private static ByteBuffer READ_PIXEL(InStream inStream, PIXEL_T pIXEL_T) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        switch (pIXEL_T) {
            case U8: {
                byteBuffer.putInt(inStream.readOpaque8());
                return (ByteBuffer)ByteBuffer.allocate(1).put(byteBuffer.get(3)).rewind();
            }
            case U16: {
                byteBuffer.putInt(inStream.readOpaque16());
                return (ByteBuffer)ByteBuffer.allocate(2).put(byteBuffer.array(), 2, 2).rewind();
            }
            case U24A: {
                return (ByteBuffer)byteBuffer.putInt(ZRLEDecoder.readOpaque24A(inStream)).rewind();
            }
            case U24B: {
                return (ByteBuffer)byteBuffer.putInt(ZRLEDecoder.readOpaque24B(inStream)).rewind();
            }
        }
        return (ByteBuffer)byteBuffer.putInt(inStream.readOpaque32()).rewind();
    }

    private void zrleDecode8(Rect rect, InStream inStream, ZlibInStream zlibInStream, ByteBuffer byteBuffer, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.ZRLE_DECODE(rect, inStream, zlibInStream, byteBuffer, pixelFormat, modifiablePixelBuffer, PIXEL_T.U8);
    }

    private void zrleDecode16(Rect rect, InStream inStream, ZlibInStream zlibInStream, ByteBuffer byteBuffer, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.ZRLE_DECODE(rect, inStream, zlibInStream, byteBuffer, pixelFormat, modifiablePixelBuffer, PIXEL_T.U16);
    }

    private void zrleDecode24A(Rect rect, InStream inStream, ZlibInStream zlibInStream, ByteBuffer byteBuffer, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.ZRLE_DECODE(rect, inStream, zlibInStream, byteBuffer, pixelFormat, modifiablePixelBuffer, PIXEL_T.U24A);
    }

    private void zrleDecode24B(Rect rect, InStream inStream, ZlibInStream zlibInStream, ByteBuffer byteBuffer, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.ZRLE_DECODE(rect, inStream, zlibInStream, byteBuffer, pixelFormat, modifiablePixelBuffer, PIXEL_T.U24B);
    }

    private void zrleDecode32(Rect rect, InStream inStream, ZlibInStream zlibInStream, ByteBuffer byteBuffer, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.ZRLE_DECODE(rect, inStream, zlibInStream, byteBuffer, pixelFormat, modifiablePixelBuffer, PIXEL_T.U32);
    }

    private void ZRLE_DECODE(Rect rect, InStream inStream, ZlibInStream zlibInStream, ByteBuffer byteBuffer, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer, PIXEL_T pIXEL_T) {
        int n = inStream.readU32();
        zlibInStream.setUnderlying(inStream, n);
        Rect rect2 = new Rect();
        rect2.tl.y = rect.tl.y;
        while (rect2.tl.y < rect.br.y) {
            rect2.br.y = Math.min(rect.br.y, rect2.tl.y + 64);
            rect2.tl.x = rect.tl.x;
            while (rect2.tl.x < rect.br.x) {
                block22: {
                    block25: {
                        int n2;
                        int n3;
                        int n4;
                        int n5;
                        ByteBuffer byteBuffer2;
                        int n6;
                        block23: {
                            int n7;
                            block24: {
                                boolean bl;
                                block21: {
                                    rect2.br.x = Math.min(rect.br.x, rect2.tl.x + 64);
                                    int n8 = zlibInStream.readU8();
                                    bl = (n8 & 0x80) != 0;
                                    n6 = n8 & 0x7F;
                                    byteBuffer2 = ByteBuffer.allocate(128 * pixelFormat.bpp / 8);
                                    for (n7 = 0; n7 < n6; ++n7) {
                                        byteBuffer2.put(ZRLEDecoder.READ_PIXEL(zlibInStream, pIXEL_T));
                                    }
                                    if (n6 != 1) break block21;
                                    ByteBuffer byteBuffer3 = ByteBuffer.allocate(pixelFormat.bpp / 8).put(byteBuffer2.array(), 0, pixelFormat.bpp / 8);
                                    modifiablePixelBuffer.fillRect(pixelFormat, rect2, byteBuffer3.array());
                                    break block22;
                                }
                                if (bl) break block23;
                                if (n6 != 0) break block24;
                                switch (pIXEL_T) {
                                    case U24A: 
                                    case U24B: {
                                        ByteBuffer byteBuffer4 = byteBuffer.duplicate();
                                        for (n5 = 0; n5 < rect2.area(); ++n5) {
                                            byteBuffer4.put(ZRLEDecoder.READ_PIXEL(zlibInStream, pIXEL_T));
                                        }
                                        break block25;
                                    }
                                    default: {
                                        zlibInStream.readBytes(byteBuffer, rect2.area() * (pixelFormat.bpp / 8));
                                        break;
                                    }
                                }
                                break block25;
                            }
                            n7 = n6 > 16 ? 8 : (n6 > 4 ? 4 : (n6 > 2 ? 2 : 1));
                            ByteBuffer byteBuffer5 = byteBuffer.duplicate();
                            for (n4 = 0; n4 < rect2.height(); ++n4) {
                                n3 = byteBuffer5.position() + rect2.width() * pixelFormat.bpp / 8;
                                n2 = 0;
                                int n9 = 0;
                                while (byteBuffer5.position() < n3) {
                                    if (n9 == 0) {
                                        n2 = zlibInStream.readU8();
                                        n9 = 8;
                                    }
                                    int n10 = n2 >> (n9 -= n7) & (1 << n7) - 1 & 0x7F;
                                    byteBuffer5.put(byteBuffer2.array(), n10 * pixelFormat.bpp / 8, pixelFormat.bpp / 8);
                                }
                            }
                            break block25;
                        }
                        if (n6 == 0) {
                            ByteBuffer byteBuffer6 = byteBuffer.duplicate();
                            n5 = byteBuffer6.position() + rect2.area() * pixelFormat.bpp / 8;
                            while (byteBuffer6.position() < n5) {
                                ByteBuffer byteBuffer7 = ZRLEDecoder.READ_PIXEL(zlibInStream, pIXEL_T);
                                n3 = 1;
                                do {
                                    n2 = zlibInStream.readU8();
                                    n3 += n2;
                                } while (n2 == 255);
                                if (n5 - byteBuffer6.position() < n3 * (pixelFormat.bpp / 8)) {
                                    System.err.println("ZRLE decode error\n");
                                    throw new Exception("ZRLE decode error");
                                }
                                while (n3-- > 0) {
                                    byteBuffer6.put(byteBuffer7);
                                }
                            }
                        } else {
                            ByteBuffer byteBuffer8 = byteBuffer.duplicate();
                            n5 = byteBuffer8.position() + rect2.area() * pixelFormat.bpp / 8;
                            while (byteBuffer8.position() < n5) {
                                n4 = zlibInStream.readU8();
                                n3 = 1;
                                if ((n4 & 0x80) != 0) {
                                    do {
                                        n2 = zlibInStream.readU8();
                                        n3 += n2;
                                    } while (n2 == 255);
                                    if (n5 - byteBuffer8.position() < n3 * (pixelFormat.bpp / 8)) {
                                        System.err.println("ZRLE decode error\n");
                                        throw new Exception("ZRLE decode error");
                                    }
                                }
                                n4 &= 0x7F;
                                while (n3-- > 0) {
                                    byteBuffer8.put(byteBuffer2.array(), n4 * pixelFormat.bpp / 8, pixelFormat.bpp / 8);
                                }
                            }
                        }
                    }
                    modifiablePixelBuffer.imageRect(pixelFormat, rect2, byteBuffer.array());
                }
                rect2.tl.x += 64;
            }
            rect2.tl.y += 64;
        }
        zlibInStream.removeUnderlying();
    }

    private static enum PIXEL_T {
        U8,
        U16,
        U24A,
        U24B,
        U32;

    }
}

