/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.math;

public class FinancialUtils {
    public static double calcInterest(double capital, double interestRate) {
        if (interestRate < 0.0) {
            throw new IllegalArgumentException("Interest-Rate must be >= 0.0");
        }
        return capital * interestRate / 100.0;
    }

    public static double calcDepreciationLinear(double capital, int duration, int timeOfInterest) {
        double r = capital / (double)duration;
        double value = capital - (double)timeOfInterest * r;
        if (value < 0.0) {
            return 0.0;
        }
        return value;
    }

    public static double calcDepreciationGeometricDegressive(double capital, double interestRatePercent, int yearOfInterest) {
        double i = interestRatePercent / 100.0;
        return capital * Math.pow(1.0 - i, yearOfInterest);
    }
}

