#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: brick
version: 0.19
id: brick-0.19-Bxf625p1aet7avsG0z1F1x
key: brick-0.19-Bxf625p1aet7avsG0z1F1x
license: BSD3
copyright: (c) Jonathan Daugherty 2015-2016
maintainer: Jonathan Daugherty <cygnus@foobox.com>
homepage: https://github.com/jtdaugherty/brick/
synopsis: A declarative terminal user interface library
description:
    Write terminal applications painlessly with '\''brick'\''! You write an
    event handler and a drawing function and the library does the rest.
    .
    .
    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui
    .
    .
    To get started, see:
    .
    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>
    .
    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>
    .
    * The demonstration programs in the '\''programs'\'' directory
    .
    .
    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.
category: Graphics
author: Jonathan Daugherty <cygnus@foobox.com>
exposed: True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.Focus Brick.Main Brick.Markup
    Brick.Types Brick.Util Brick.Widgets.Border
    Brick.Widgets.Border.Style Brick.Widgets.Center Brick.Widgets.Core
    Brick.Widgets.Dialog Brick.Widgets.Edit Brick.Widgets.List
    Brick.Widgets.ProgressBar Data.Text.Markup
hidden-modules: Brick.Types.TH Brick.Types.Internal
                Brick.Widgets.Internal
abi: 0ea6376ffb802a5507f69c40b5c73496
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/brick-0.19
library-dirs: /usr/lib/ghc-8.0.2/site-local/brick-0.19
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/brick-0.19
hs-libraries: HSbrick-0.19-Bxf625p1aet7avsG0z1F1x
depends:
    base-4.9.1.0 containers-0.5.7.1
    contravariant-1.4-8XNcYhxZMQPHL9Afkgrfdc
    data-clist-0.1.1.0-9N3lnT7e26qEPJbDLHTJbo deepseq-1.4.2.0
    dlist-0.8.0.3-BHFBNaw8k6n9WiaUNzoXpk
    microlens-0.4.8.0-5PXN9DedWooJg6UJ24ter0
    microlens-mtl-0.1.11.0-JZGlAY1k7Eo2CcDKB6BH2V
    microlens-th-0.4.1.1-DS5mBQOVXPfALmfN2UZZ6b
    stm-2.4.4.1-iSYwp3RMY11sHCifJ3gtR template-haskell-2.11.1.0
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq
    text-zipper-0.10-41KFTca4F3zFG9zT2Vrsjp transformers-0.5.2.0
    vector-0.12.0.1-692PQMDMB6pIQ1uGwefDcQ
    vty-5.15.1-5IrjrUyzgZECvI31r49Dzy
haddock-interfaces: /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html: /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
