/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps;

import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.BlockScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitorWithResult;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J!\u0010\u0015\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/ReturnValueInstruction;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/jumps/AbstractJumpInstruction;", "returnExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "blockScope", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;", "targetLabel", "Lorg/jetbrains/kotlin/cfg/Label;", "returnedValue", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;Lorg/jetbrains/kotlin/cfg/Label;Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;)V", "inputValues", "", "getInputValues", "()Ljava/util/List;", "returnExpressionIfAny", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getReturnExpressionIfAny", "()Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getReturnedValue", "()Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "accept", "", "visitor", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitor;", "R", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;", "(Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/InstructionVisitorWithResult;)Ljava/lang/Object;", "createCopy", "newLabel", "toString", "", "kotlin-compiler"})
public final class ReturnValueInstruction
extends AbstractJumpInstruction {
    @Nullable
    private final KtReturnExpression returnExpressionIfAny;
    @NotNull
    private final PseudoValue returnedValue;

    @Override
    @NotNull
    public List<PseudoValue> getInputValues() {
        List<PseudoValue> list2 = Collections.singletonList(this.returnedValue);
        Intrinsics.checkExpressionValueIsNotNull(list2, "Collections.singletonList(returnedValue)");
        return list2;
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor2) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        visitor2.visitReturnValue(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<? extends R> visitor2) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitReturnValue(this);
    }

    @NotNull
    public String toString() {
        return "ret(*|" + this.returnedValue + ") " + this.getTargetLabel();
    }

    @Override
    @NotNull
    protected AbstractJumpInstruction createCopy(@NotNull Label newLabel, @NotNull BlockScope blockScope) {
        Intrinsics.checkParameterIsNotNull(newLabel, "newLabel");
        Intrinsics.checkParameterIsNotNull(blockScope, "blockScope");
        KtElement ktElement = this.getElement();
        if (ktElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        return new ReturnValueInstruction((KtExpression)ktElement, blockScope, newLabel, this.returnedValue);
    }

    @Nullable
    public final KtReturnExpression getReturnExpressionIfAny() {
        return this.returnExpressionIfAny;
    }

    @NotNull
    public final PseudoValue getReturnedValue() {
        return this.returnedValue;
    }

    public ReturnValueInstruction(@NotNull KtExpression returnExpression, @NotNull BlockScope blockScope, @NotNull Label targetLabel, @NotNull PseudoValue returnedValue) {
        Intrinsics.checkParameterIsNotNull(returnExpression, "returnExpression");
        Intrinsics.checkParameterIsNotNull(blockScope, "blockScope");
        Intrinsics.checkParameterIsNotNull(targetLabel, "targetLabel");
        Intrinsics.checkParameterIsNotNull(returnedValue, "returnedValue");
        super(returnExpression, targetLabel, blockScope);
        this.returnedValue = returnedValue;
        KtElement ktElement = this.getElement();
        if (!(ktElement instanceof KtReturnExpression)) {
            ktElement = null;
        }
        this.returnExpressionIfAny = (KtReturnExpression)ktElement;
    }
}

