/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedValueDescriptor;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxedValuesCollection;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

public class RedundantBoxingMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode node) {
        if (internalClassName == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(0);
        }
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(1);
        }
        RedundantBoxingInterpreter interpreter = new RedundantBoxingInterpreter(node.instructions);
        Frame<BasicValue>[] frames2 = RedundantBoxingMethodTransformer.analyze(internalClassName, node, interpreter);
        RedundantBoxingMethodTransformer.interpretPopInstructionsForBoxedValues(interpreter, node, frames2);
        RedundantBoxedValuesCollection valuesToOptimize = interpreter.getCandidatesBoxedValues();
        if (!valuesToOptimize.isEmpty()) {
            RedundantBoxingMethodTransformer.removeValuesClashingWithVariables(valuesToOptimize, node, frames2);
            RedundantBoxingMethodTransformer.adaptLocalVariableTableForBoxedValues(node, frames2);
            UtilKt.remapLocalVariables(node, RedundantBoxingMethodTransformer.buildVariablesRemapping(valuesToOptimize, node));
            RedundantBoxingMethodTransformer.adaptInstructionsForBoxedValues(node, valuesToOptimize);
        }
    }

    private static void interpretPopInstructionsForBoxedValues(@NotNull RedundantBoxingInterpreter interpreter, @NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        if (interpreter == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(2);
        }
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(3);
        }
        if (frames2 == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(4);
        }
        for (int i = 0; i < node.instructions.size(); ++i) {
            AbstractInsnNode insn = node.instructions.get(i);
            if (insn.getOpcode() != 87 && insn.getOpcode() != 88 || frames2[i] == null) continue;
            BasicValue top = frames2[i].getStack(frames2[i].getStackSize() - 1);
            interpreter.processPopInstruction(insn, top);
            if (top.getSize() != 1 || insn.getOpcode() != 88) continue;
            interpreter.processPopInstruction(insn, frames2[i].getStack(frames2[i].getStackSize() - 2));
        }
    }

    private static void removeValuesClashingWithVariables(@NotNull RedundantBoxedValuesCollection values, @NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        if (values == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(5);
        }
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(6);
        }
        if (frames2 == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(7);
        }
        while (RedundantBoxingMethodTransformer.removeValuesClashingWithVariablesPass(values, node, frames2)) {
        }
    }

    private static boolean removeValuesClashingWithVariablesPass(@NotNull RedundantBoxedValuesCollection values, @NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        if (values == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(8);
        }
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(9);
        }
        if (frames2 == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(10);
        }
        boolean needToRepeat = false;
        for (LocalVariableNode localVariableNode : node.localVariables) {
            BoxedValueDescriptor firstBoxed;
            List<BasicValue> variableValues;
            List<BasicValue> boxed;
            if (Type.getType(localVariableNode.desc).getSort() != 10 || (boxed = CollectionsKt.filter(variableValues = RedundantBoxingMethodTransformer.getValuesStoredOrLoadedToVariable(localVariableNode, node, frames2), value -> value instanceof BoxedBasicValue)).isEmpty() || !RedundantBoxingMethodTransformer.isUnsafeToRemoveBoxingForConnectedValues(variableValues, (firstBoxed = ((BoxedBasicValue)boxed.iterator().next()).getDescriptor()).getUnboxedType())) continue;
            for (BasicValue value2 : variableValues) {
                BoxedValueDescriptor descriptor2;
                if (!(value2 instanceof BoxedBasicValue) || !(descriptor2 = ((BoxedBasicValue)value2).getDescriptor()).isSafeToRemove()) continue;
                values.remove(descriptor2);
                needToRepeat = true;
            }
        }
        return needToRepeat;
    }

    private static boolean isUnsafeToRemoveBoxingForConnectedValues(List<BasicValue> usedValues, Type unboxedType) {
        return CollectionsKt.any(usedValues, input -> {
            if (input == StrictBasicValue.UNINITIALIZED_VALUE) {
                return false;
            }
            if (!(input instanceof BoxedBasicValue)) {
                return true;
            }
            BoxedValueDescriptor descriptor2 = ((BoxedBasicValue)input).getDescriptor();
            return !descriptor2.isSafeToRemove() || !descriptor2.getUnboxedType().equals(unboxedType);
        });
    }

    private static void adaptLocalVariableTableForBoxedValues(@NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(11);
        }
        if (frames2 == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(12);
        }
        for (LocalVariableNode localVariableNode : node.localVariables) {
            if (Type.getType(localVariableNode.desc).getSort() != 10) continue;
            for (BasicValue value : RedundantBoxingMethodTransformer.getValuesStoredOrLoadedToVariable(localVariableNode, node, frames2)) {
                BoxedValueDescriptor descriptor2;
                if (!(value instanceof BoxedBasicValue) || !(descriptor2 = ((BoxedBasicValue)value).getDescriptor()).isSafeToRemove()) continue;
                localVariableNode.desc = descriptor2.getUnboxedType().getDescriptor();
            }
        }
    }

    @NotNull
    private static List<BasicValue> getValuesStoredOrLoadedToVariable(@NotNull LocalVariableNode localVariableNode, @NotNull MethodNode node, @NotNull Frame<BasicValue>[] frames2) {
        BasicValue localVarValue;
        if (localVariableNode == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(13);
        }
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(14);
        }
        if (frames2 == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(15);
        }
        ArrayList<BasicValue> values = new ArrayList<BasicValue>();
        InsnList insnList = node.instructions;
        int from = insnList.indexOf(localVariableNode.start) + 1;
        int to = insnList.indexOf(localVariableNode.end) - 1;
        Frame<BasicValue> frameForFromInstr = frames2[from];
        if (frameForFromInstr != null && (localVarValue = frameForFromInstr.getLocal(localVariableNode.index)) != null) {
            values.add(localVarValue);
        }
        for (int i = from; i <= to; ++i) {
            AbstractInsnNode insn;
            if (i < 0 || i >= insnList.size() || (insn = insnList.get(i)).getOpcode() != 58 && insn.getOpcode() != 25 || ((VarInsnNode)insn).var != localVariableNode.index || frames2[i] == null) continue;
            if (insn.getOpcode() == 58) {
                values.add(frames2[i].getStack(frames2[i].getStackSize() - 1));
                continue;
            }
            values.add(frames2[i].getLocal(((VarInsnNode)insn).var));
        }
        ArrayList<BasicValue> arrayList = values;
        if (arrayList == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private static int[] buildVariablesRemapping(@NotNull RedundantBoxedValuesCollection values, @NotNull MethodNode node) {
        if (values == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(17);
        }
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(18);
        }
        HashSet<Integer> doubleSizedVars = new HashSet<Integer>();
        for (BoxedValueDescriptor valueDescriptor : values) {
            if (!valueDescriptor.isDoubleSize()) continue;
            doubleSizedVars.addAll(valueDescriptor.getVariablesIndexes());
        }
        node.maxLocals += doubleSizedVars.size();
        int[] remapping = new int[node.maxLocals];
        for (int i = 0; i < remapping.length; ++i) {
            remapping[i] = i;
        }
        Iterator iterator2 = doubleSizedVars.iterator();
        while (iterator2.hasNext()) {
            int varIndex = (Integer)iterator2.next();
            int i = varIndex + 1;
            while (i < remapping.length) {
                int n = i++;
                remapping[n] = remapping[n] + 1;
            }
        }
        if (remapping == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(19);
        }
        return remapping;
    }

    private static void adaptInstructionsForBoxedValues(@NotNull MethodNode node, @NotNull RedundantBoxedValuesCollection values) {
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(20);
        }
        if (values == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(21);
        }
        for (BoxedValueDescriptor value : values) {
            RedundantBoxingMethodTransformer.adaptInstructionsForBoxedValue(node, value);
        }
    }

    private static void adaptInstructionsForBoxedValue(@NotNull MethodNode node, @NotNull BoxedValueDescriptor value) {
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(22);
        }
        if (value == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(23);
        }
        RedundantBoxingMethodTransformer.adaptBoxingInstruction(node, value);
        for (Pair<AbstractInsnNode, Type> cast : value.getUnboxingWithCastInsns()) {
            RedundantBoxingMethodTransformer.adaptCastInstruction(node, value, cast);
        }
        for (AbstractInsnNode insn : value.getAssociatedInsns()) {
            RedundantBoxingMethodTransformer.adaptInstruction(node, insn, value);
        }
    }

    private static void adaptBoxingInstruction(@NotNull MethodNode node, @NotNull BoxedValueDescriptor value) {
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(24);
        }
        if (value == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(25);
        }
        if (!value.isFromProgressionIterator()) {
            node.instructions.remove(value.getBoxingInsn());
        } else {
            ProgressionIteratorBasicValue iterator2 = value.getProgressionIterator();
            assert (iterator2 != null) : "iterator should not be null because isFromProgressionIterator returns true";
            node.instructions.insertBefore(value.getBoxingInsn(), new TypeInsnNode(192, iterator2.getType().getInternalName()));
            node.instructions.set(value.getBoxingInsn(), new MethodInsnNode(182, iterator2.getType().getInternalName(), iterator2.getNextMethodName(), iterator2.getNextMethodDesc(), false));
        }
    }

    private static void adaptCastInstruction(@NotNull MethodNode node, @NotNull BoxedValueDescriptor value, @NotNull Pair<AbstractInsnNode, Type> castWithType) {
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(26);
        }
        if (value == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(27);
        }
        if (castWithType == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(28);
        }
        AbstractInsnNode castInsn = castWithType.getFirst();
        MethodNode castInsnsListener = new MethodNode(327680);
        new InstructionAdapter(castInsnsListener).cast(value.getUnboxedType(), castWithType.getSecond());
        for (AbstractInsnNode insn : castInsnsListener.instructions.toArray()) {
            node.instructions.insertBefore(castInsn, insn);
        }
        node.instructions.remove(castInsn);
    }

    private static void adaptInstruction(@NotNull MethodNode node, @NotNull AbstractInsnNode insn, @NotNull BoxedValueDescriptor value) {
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(29);
        }
        if (insn == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(30);
        }
        if (value == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(31);
        }
        boolean isDoubleSize = value.isDoubleSize();
        switch (insn.getOpcode()) {
            case 87: {
                if (!isDoubleSize) break;
                node.instructions.set(insn, new InsnNode(88));
                break;
            }
            case 89: {
                if (!isDoubleSize) break;
                node.instructions.set(insn, new InsnNode(92));
                break;
            }
            case 25: 
            case 58: {
                int intVarOpcode = insn.getOpcode() == 58 ? 54 : 21;
                node.instructions.set(insn, new VarInsnNode(value.getUnboxedType().getOpcode(intVarOpcode), ((VarInsnNode)insn).var));
                break;
            }
            case 193: {
                node.instructions.insertBefore(insn, new InsnNode(isDoubleSize ? 88 : 87));
                node.instructions.set(insn, new InsnNode(4));
                break;
            }
            case 184: {
                if (BoxingInterpreterKt.isAreEqualIntrinsic(insn)) {
                    RedundantBoxingMethodTransformer.adaptAreEqualIntrinsic(node, insn, value);
                    break;
                }
            }
            default: {
                node.instructions.remove(insn);
            }
        }
    }

    private static void adaptAreEqualIntrinsic(@NotNull MethodNode node, @NotNull AbstractInsnNode insn, @NotNull BoxedValueDescriptor value) {
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(32);
        }
        if (insn == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(33);
        }
        if (value == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(34);
        }
        Type unboxedType = value.getUnboxedType();
        switch (unboxedType.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                RedundantBoxingMethodTransformer.adaptAreEqualIntrinsicForInt(node, insn);
                break;
            }
            case 7: {
                RedundantBoxingMethodTransformer.adaptAreEqualIntrinsicForLong(node, insn);
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected unboxed type kind: " + unboxedType));
            }
        }
    }

    private static void adaptAreEqualIntrinsicForInt(@NotNull MethodNode node, @NotNull AbstractInsnNode insn) {
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(35);
        }
        if (insn == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(36);
        }
        LabelNode lNotEqual = new LabelNode(new Label());
        LabelNode lDone = new LabelNode(new Label());
        node.instructions.insertBefore(insn, new JumpInsnNode(160, lNotEqual));
        node.instructions.insertBefore(insn, new InsnNode(4));
        node.instructions.insertBefore(insn, new JumpInsnNode(167, lDone));
        node.instructions.insertBefore(insn, lNotEqual);
        node.instructions.insertBefore(insn, new InsnNode(3));
        node.instructions.insertBefore(insn, lDone);
        node.instructions.remove(insn);
    }

    private static void adaptAreEqualIntrinsicForLong(@NotNull MethodNode node, @NotNull AbstractInsnNode insn) {
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(37);
        }
        if (insn == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(38);
        }
        node.instructions.insertBefore(insn, new InsnNode(148));
        RedundantBoxingMethodTransformer.ifEqual1Else0(node, insn);
        node.instructions.remove(insn);
    }

    private static void ifEqual1Else0(@NotNull MethodNode node, @NotNull AbstractInsnNode insn) {
        if (node == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(39);
        }
        if (insn == null) {
            RedundantBoxingMethodTransformer.$$$reportNull$$$0(40);
        }
        LabelNode lNotEqual = new LabelNode(new Label());
        LabelNode lDone = new LabelNode(new Label());
        node.instructions.insertBefore(insn, new JumpInsnNode(154, lNotEqual));
        node.instructions.insertBefore(insn, new InsnNode(4));
        node.instructions.insertBefore(insn, new JumpInsnNode(167, lDone));
        node.instructions.insertBefore(insn, lNotEqual);
        node.instructions.insertBefore(insn, new InsnNode(3));
        node.instructions.insertBefore(insn, lDone);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalClassName";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
            case 5: 
            case 8: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localVariableNode";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castWithType";
                break;
            }
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingMethodTransformer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesStoredOrLoadedToVariable";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVariablesRemapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transform";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "interpretPopInstructionsForBoxedValues";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeValuesClashingWithVariables";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeValuesClashingWithVariablesPass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "adaptLocalVariableTableForBoxedValues";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getValuesStoredOrLoadedToVariable";
                break;
            }
            case 16: 
            case 19: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildVariablesRemapping";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "adaptInstructionsForBoxedValues";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "adaptInstructionsForBoxedValue";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "adaptBoxingInstruction";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "adaptCastInstruction";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "adaptInstruction";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "adaptAreEqualIntrinsic";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "adaptAreEqualIntrinsicForInt";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "adaptAreEqualIntrinsicForLong";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "ifEqual1Else0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

