/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;

public class EnumConstantElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.EnumConstantElement");

    public EnumConstantElement() {
        super(ENUM_CONSTANT);
    }

    @Override
    public int getTextOffset() {
        return this.findChildByRole(9).getStartOffset();
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 7: {
                return PsiImplUtil.findDocComment(this);
            }
            case 9: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 73: {
                return this.findChildByType(EXPRESSION_LIST);
            }
            case 70: {
                return this.findChildByType(ENUM_CONSTANT_INITIALIZER);
            }
            case 8: 
        }
        return this.findChildByType(JavaElementType.MODIFIER_LIST);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaDocElementType.DOC_COMMENT) {
            return this.getChildRole(child, 7);
        }
        if (i == JavaTokenType.C_STYLE_COMMENT || i == JavaTokenType.END_OF_LINE_COMMENT) {
            return 0;
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        if (i == ENUM_CONSTANT_INITIALIZER) {
            return 70;
        }
        if (i == EXPRESSION_LIST) {
            return 73;
        }
        if (i == MODIFIER_LIST) {
            return 8;
        }
        return 0;
    }
}

