/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.compiler;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.java.sen.compiler.StringCTokenTuple;
import net.java.sen.dictionary.CToken;
import net.java.sen.util.IOUtils;

public class VirtualTupleList
implements Closeable {
    private RandomAccessFile file = null;
    private BufferedOutputStream bos = null;
    private FileOutputStream fos = null;
    private MappedByteBuffer mappedBuffer = null;
    private DataOutputStream outputStream;
    private List<Integer> indices = new ArrayList<Integer>();
    private final Comparator<Integer> comparator = new VirtualListComparator();

    public void add(String string, CToken ctoken) throws IOException {
        int position = this.outputStream.size();
        CToken.write(this.outputStream, ctoken);
        this.outputStream.writeShort(string.length());
        this.outputStream.writeChars(string);
        this.indices.add(position);
    }

    public StringCTokenTuple get(int index) {
        int position = this.indices.get(index);
        this.mappedBuffer.position(position);
        CToken ctoken = new CToken();
        ctoken.read(this.mappedBuffer);
        int numChars = this.mappedBuffer.getShort();
        char[] stringChars = new char[numChars];
        for (int i = 0; i < numChars; ++i) {
            stringChars[i] = this.mappedBuffer.getChar();
        }
        String string = new String(stringChars);
        return new StringCTokenTuple(string, ctoken);
    }

    private String getString(int position) {
        this.mappedBuffer.position((int)((long)position + 14L));
        int numChars = this.mappedBuffer.getShort();
        char[] stringChars = new char[numChars];
        for (int i = 0; i < numChars; ++i) {
            stringChars[i] = this.mappedBuffer.getChar();
        }
        return new String(stringChars);
    }

    public void sort() throws IOException {
        this.outputStream.flush();
        this.mappedBuffer = this.file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.file.length());
        Collections.sort(this.indices, this.comparator);
    }

    public int size() {
        return this.indices.size();
    }

    public VirtualTupleList() throws IOException {
        File tempFile = File.createTempFile("_tok", null);
        tempFile.deleteOnExit();
        this.file = new RandomAccessFile(tempFile, "rw");
        this.fos = new FileOutputStream(tempFile);
        this.bos = new BufferedOutputStream(this.fos);
        this.outputStream = new DataOutputStream(this.bos);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.file, this.fos, this.bos, this.outputStream);
    }

    private class VirtualListComparator
    implements Comparator<Integer> {
        private VirtualListComparator() {
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            String first = VirtualTupleList.this.getString(o1);
            String second = VirtualTupleList.this.getString(o2);
            return first.compareTo(second);
        }
    }
}

