/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class LongSentenceRule
extends Rule {
    private static final int DEFAULT_MAX_WORDS = 40;
    private static final Pattern NON_WORD_REGEX = Pattern.compile("[.?!:;,~\u2019'\"\u201e\u201c\u00bb\u00ab\u201a\u2018\u203a\u2039()\\[\\]-]");
    private static final boolean DEFAULT_INACTIVE = false;
    private final int maxWords;

    public LongSentenceRule(ResourceBundle messages, int maxSentenceLength, boolean defaultActive) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        if (maxSentenceLength <= 0) {
            throw new IllegalArgumentException("maxSentenceLength must be > 0: " + maxSentenceLength);
        }
        this.maxWords = maxSentenceLength;
        if (!defaultActive) {
            this.setDefaultOff();
        }
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public LongSentenceRule(ResourceBundle messages, int maxSentenceLength) {
        this(messages, maxSentenceLength, false);
    }

    public LongSentenceRule(ResourceBundle messages) {
        this(messages, 40, false);
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(this.messages.getString("long_sentence_rule_desc"), this.maxWords);
    }

    @Override
    public String getId() {
        return "TOO_LONG_SENTENCE";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        String msg = MessageFormat.format(this.messages.getString("long_sentence_rule_msg"), this.maxWords);
        int numWords = 0;
        int pos = 0;
        if (tokens.length < this.maxWords + 1) {
            return this.toRuleMatchArray(ruleMatches);
        }
        for (AnalyzedTokenReadings aToken : tokens) {
            String token = aToken.getToken();
            pos += token.length();
            if (aToken.isSentenceStart() || aToken.isSentenceEnd() || NON_WORD_REGEX.matcher(token).matches()) continue;
            ++numWords;
        }
        if (numWords > this.maxWords) {
            RuleMatch ruleMatch = new RuleMatch(this, 0, pos, msg);
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

