/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class FloatingTextArea {
    protected JScrollPane fEditScrollContainer;
    protected JEditorPane fEditWidget = new JEditorPane();
    protected Container fContainer;

    public FloatingTextArea() {
        this.fEditScrollContainer = new JScrollPane(this.fEditWidget, 22, 31);
        this.fEditScrollContainer.setCursor(Cursor.getPredefinedCursor(0));
        this.fEditScrollContainer.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    public void createOverlay(Container container) {
        this.createOverlay(container, null);
    }

    public void createOverlay(Container container, Font font) {
        container.add((Component)this.fEditScrollContainer, 0);
        if (font != null) {
            this.fEditWidget.setFont(font);
        }
        this.fContainer = container;
    }

    public void setBounds(Rectangle r, String text) {
        this.fEditWidget.setText(text);
        this.fEditScrollContainer.setBounds(r.x, r.y, r.width, r.height);
        this.fEditScrollContainer.setVisible(true);
        this.fEditWidget.setCaretPosition(0);
        this.fEditWidget.requestFocus();
    }

    public String getText() {
        return this.fEditWidget.getText();
    }

    public Dimension getPreferredSize(int cols) {
        return new Dimension(this.fEditWidget.getWidth(), this.fEditWidget.getHeight());
    }

    public void endOverlay() {
        this.fContainer.requestFocus();
        if (this.fEditScrollContainer != null) {
            this.fEditScrollContainer.setVisible(false);
            this.fContainer.remove(this.fEditScrollContainer);
            Rectangle bounds = this.fEditScrollContainer.getBounds();
            this.fContainer.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }
}

