/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.attributes;

import freemind.controller.filter.util.SortedListModel;
import freemind.modes.attributes.AttributeRegistry;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

class AttributeRegistryComboBoxColumnModel
extends AbstractListModel
implements TableModelListener,
ComboBoxModel,
SortedListModel {
    private final AttributeRegistry model;
    private Object selectedItem;

    public AttributeRegistryComboBoxColumnModel(AttributeRegistry model) {
        this.model = model;
        model.getTableModel().addTableModelListener(this);
    }

    @Override
    public void setSelectedItem(Object o) {
        this.selectedItem = o;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return this.model.size();
    }

    public Object getElementAt(int row) {
        return this.model.getKey(row);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == -1) {
            this.fireIntervalRemoved(this, e.getFirstRow(), e.getLastRow());
            return;
        }
        if (e.getType() == 0) {
            this.fireContentsChanged(this, e.getFirstRow(), e.getLastRow());
            return;
        }
        if (e.getType() == 1) {
            this.fireIntervalAdded(this, e.getFirstRow(), e.getLastRow());
            return;
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object o) {
        return this.model.containsElement(o.toString());
    }

    @Override
    public void add(Object o) {
        String s = o.toString();
        if (-1 == this.model.indexOf(s)) {
            this.model.getAttributeController().performRegistryAttributeValue(s, "");
        }
    }

    @Override
    public void replace(Object oldO, Object newO) {
        this.model.getAttributeController().performReplaceAtributeName(oldO.toString(), newO.toString());
    }

    @Override
    public void remove(Object o) {
        this.model.removeAtribute(o);
    }

    @Override
    public int getIndexOf(Object o) {
        return this.model.indexOf(o.toString());
    }
}

